/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;

public class Jre
implements IValidatable {
    public static final String VERSION_PATTERN = "(\\d\\.){2}\\d(_\\d+)?";
    public static final String PATH = "jrepath";
    public static final String MIN_VERSION = "javamin";
    public static final String MAX_VERSION = "javamax";
    public static final String ARGS = "jvmArgs";
    private String path;
    private String minVersion;
    private String maxVersion;
    private int initialHeapSize;
    private int maxHeapSize;
    private String args;

    public void checkInvariants() {
        Validator.checkOptString(this.minVersion, 10, VERSION_PATTERN, "jre.minVersion", "Minimum JRE version should be x.x.x[_xx]");
        Validator.checkOptString(this.maxVersion, 10, VERSION_PATTERN, "jre.maxVersion", "Maximum JRE version should be x.x.x[_xx]");
        if (Validator.isEmpty(this.path)) {
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.path", "Specify embedded JRE path or/and minimum JRE version.");
        } else {
            Validator.checkRelativeWinPath(this.path, "jre.path", "Embedded JRE path must be a path relative to the executable.");
        }
        if (!Validator.isEmpty(this.maxVersion)) {
            Validator.checkFalse(Validator.isEmpty(this.minVersion), "jre.minVersion", "Specify minimum JRE version.");
            Validator.checkTrue(this.minVersion.compareTo(this.maxVersion) <= 0, "jre.minVersion", "Minimum JRE version is greater than the maximum.");
        }
        Validator.checkTrue(this.initialHeapSize >= 0, "jre.initialHeapSize", "Initial heap size cannot be negative, specify 0 or leave the field blank to use the JVM default.");
        Validator.checkTrue(this.maxHeapSize == 0 || this.initialHeapSize <= this.maxHeapSize, "jre.maxHeapSize", "Maximum heap size cannot be less than the initial size, specify 0 or leave the field blank to use the JVM default.");
        Validator.checkOptString(this.args, 512, "jre.args", "JVM arguments");
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public void setMaxVersion(String maxVersion) {
        this.maxVersion = maxVersion;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public int getInitialHeapSize() {
        return this.initialHeapSize;
    }

    public void setInitialHeapSize(int initialHeapSize) {
        this.initialHeapSize = initialHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }
}

