/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.config;

import net.sf.launch4j.binding.IValidatable;
import net.sf.launch4j.binding.Validator;

public class VersionInfo
implements IValidatable {
    public static final String VERSION_PATTERN = "(\\d+\\.){3}\\d+";
    private static final int MAX_LEN = 150;
    private String fileVersion;
    private String txtFileVersion;
    private String fileDescription;
    private String copyright;
    private String productVersion;
    private String txtProductVersion;
    private String productName;
    private String companyName;
    private String internalName;
    private String originalFilename;

    public void checkInvariants() {
        Validator.checkString(this.fileVersion, 20, VERSION_PATTERN, "versionInfo.fileVersion", "File version, should be 'x.x.x.x'");
        Validator.checkString(this.txtFileVersion, 50, "versionInfo.txtFileVersion", "Free form file version");
        Validator.checkString(this.fileDescription, 150, "versionInfo.fileDescription", "File description");
        Validator.checkString(this.copyright, 150, "versionInfo.copyright", "Copyright");
        Validator.checkString(this.productVersion, 20, VERSION_PATTERN, "versionInfo.productVersion", "Product version, should be 'x.x.x.x'");
        Validator.checkString(this.txtProductVersion, 50, "versionInfo.txtProductVersion", "Free from product version");
        Validator.checkString(this.productName, 150, "versionInfo.productName", "Product name");
        Validator.checkOptString(this.companyName, 150, "versionInfo.companyName", "Company name");
        Validator.checkString(this.internalName, 50, "versionInfo.internalName", "Internal name");
        Validator.checkTrue(!this.internalName.endsWith(".exe"), "versionInfo.internalName", "Internal name shouldn't have the .exe extension.");
        Validator.checkString(this.originalFilename, 50, "versionInfo.originalFilename", "Original filename");
        Validator.checkTrue(this.originalFilename.endsWith(".exe"), "versionInfo.originalFilename", "Original filename should end with the .exe extension.");
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getFileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
    }

    public String getFileVersion() {
        return this.fileVersion;
    }

    public void setFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public void setInternalName(String internalName) {
        this.internalName = internalName;
    }

    public String getOriginalFilename() {
        return this.originalFilename;
    }

    public void setOriginalFilename(String originalFilename) {
        this.originalFilename = originalFilename;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getTxtFileVersion() {
        return this.txtFileVersion;
    }

    public void setTxtFileVersion(String txtFileVersion) {
        this.txtFileVersion = txtFileVersion;
    }

    public String getTxtProductVersion() {
        return this.txtProductVersion;
    }

    public void setTxtProductVersion(String txtProductVersion) {
        this.txtProductVersion = txtProductVersion;
    }
}

