/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.formimpl;

import com.jgoodies.plaf.Options;
import com.jgoodies.plaf.plastic.PlasticXPLookAndFeel;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import net.sf.launch4j.Builder;
import net.sf.launch4j.BuilderException;
import net.sf.launch4j.ExecException;
import net.sf.launch4j.FileChooserFilter;
import net.sf.launch4j.Log;
import net.sf.launch4j.Util;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.InvariantViolationException;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.ConfigPersisterException;
import net.sf.launch4j.formimpl.ConfigFormImpl;
import net.sf.launch4j.formimpl.GlassPane;

public class MainFrame
extends JFrame {
    private static MainFrame _instance;
    private final JToolBar _toolBar;
    private final JButton _runButton;
    private final ConfigFormImpl _configForm;
    private final JFileChooser _fileChooser = new JFileChooser();
    private File _outfile;
    private boolean _saved = false;
    static /* synthetic */ Class class$0;

    public static void createInstance() {
        try {
            Toolkit.getDefaultToolkit().setDynamicLayout(true);
            System.setProperty("sun.awt.noerasebackground", "true");
            Options.setDefaultIconSize((Dimension)new Dimension(16, 16));
            Options.setUseNarrowButtons((boolean)false);
            Options.setPopupDropShadowEnabled((boolean)true);
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            _instance = new MainFrame();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public static MainFrame getInstance() {
        return _instance;
    }

    public MainFrame() {
        this.showConfigName(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new ExitWindowListener());
        this.setGlassPane(new GlassPane(this));
        this._fileChooser.setFileFilter(new FileChooserFilter("launch4j config files (.xml, .cfg)", new String[]{".xml", ".cfg"}));
        this._toolBar = new JToolBar();
        this._toolBar.setFloatable(false);
        this._toolBar.setRollover(true);
        this.addButton("images/new.png", "New configuration", new NewActionListener());
        this.addButton("images/open.png", "Open configuration or import 1.x", new OpenActionListener());
        this.addButton("images/save.png", "Save configuration", new SaveActionListener());
        this._toolBar.addSeparator();
        this.addButton("images/build.png", "Build wrapper", new BuildActionListener());
        this._runButton = this.addButton("images/run.png", "Test wrapper", new RunActionListener());
        this.setRunEnabled(false);
        this._toolBar.addSeparator();
        this.addButton("images/info.png", "About launch4j", new AboutActionListener());
        this._configForm = new ConfigFormImpl();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._toolBar, "North");
        this.getContentPane().add((Component)this._configForm, "Center");
        this._configForm.clear();
        this.pack();
        Dimension scr = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension fr = this.getSize();
        fr.height += 100;
        this.setBounds((scr.width - fr.width) / 2, (scr.height - fr.height) / 2, fr.width, fr.height);
        this.setVisible(true);
    }

    private JButton addButton(String iconPath, String tooltip, ActionListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.launch4j.formimpl.MainFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageIcon icon = new ImageIcon(clazz.getClassLoader().getResource(iconPath));
        JButton b = new JButton(icon);
        b.setToolTipText(tooltip);
        b.addActionListener(l);
        this._toolBar.add(b);
        return b;
    }

    public void info(String text) {
        JOptionPane.showMessageDialog(this, text, "launch4j 2.0.RC3", 1);
    }

    public void warn(String text) {
        JOptionPane.showMessageDialog(this, text, "launch4j 2.0.RC3", 2);
    }

    public void warn(InvariantViolationException e) {
        e.getBinding().markInvalid();
        this.warn(e.getMessage());
        e.getBinding().markValid();
    }

    private boolean isModified() {
        return !this._configForm.isModified() || JOptionPane.showConfirmDialog(this, "Discard changes?", "Confirm", 0) == 0;
    }

    private boolean save() {
        try {
            this._configForm.get(ConfigPersister.getInstance().getConfig());
            if (this._fileChooser.showSaveDialog(this) == 0) {
                File f = this._fileChooser.getSelectedFile();
                if (!f.getPath().endsWith(".xml")) {
                    f = new File(String.valueOf(f.getPath()) + ".xml");
                }
                ConfigPersister.getInstance().save(f);
                this._saved = true;
                this.showConfigName(f);
                return true;
            }
            return false;
        }
        catch (InvariantViolationException ex) {
            this.warn(ex);
            return false;
        }
        catch (BindingException ex) {
            this.warn(ex.getMessage());
            return false;
        }
        catch (ConfigPersisterException ex) {
            this.warn(ex.getMessage());
            return false;
        }
    }

    private void showConfigName(File config) {
        this.setTitle("launch4j 2.0.RC3 - " + (config != null ? config.getName() : "untitled"));
    }

    private void setRunEnabled(boolean enabled) {
        if (!enabled) {
            this._outfile = null;
        }
        this._runButton.setEnabled(enabled);
    }

    static /* synthetic */ File access$9(MainFrame mainFrame) {
        return mainFrame._outfile;
    }

    private class ExitWindowListener
    extends WindowAdapter {
        ExitWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            if (MainFrame.this.isModified()) {
                System.exit(0);
            }
        }
    }

    private class NewActionListener
    implements ActionListener {
        NewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this.isModified()) {
                ConfigPersister.getInstance().createBlank();
                MainFrame.this._configForm.put(ConfigPersister.getInstance().getConfig());
            }
            MainFrame.this._saved = false;
            MainFrame.this.showConfigName(null);
            MainFrame.this.setRunEnabled(false);
        }
    }

    private class OpenActionListener
    implements ActionListener {
        OpenActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (MainFrame.this.isModified() && MainFrame.this._fileChooser.showOpenDialog(MainFrame.this) == 0) {
                    File f = MainFrame.this._fileChooser.getSelectedFile();
                    if (f.getPath().endsWith(".xml")) {
                        ConfigPersister.getInstance().load(f);
                        MainFrame.this._saved = true;
                    } else {
                        ConfigPersister.getInstance().loadVersion1(f);
                        MainFrame.this._saved = false;
                    }
                    MainFrame.this._configForm.put(ConfigPersister.getInstance().getConfig());
                    MainFrame.this.showConfigName(f);
                    MainFrame.this.setRunEnabled(false);
                }
            }
            catch (ConfigPersisterException ex) {
                MainFrame.this.warn(ex.getMessage());
            }
        }
    }

    private class SaveActionListener
    implements ActionListener {
        SaveActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.save();
        }
    }

    private class BuildActionListener
    implements ActionListener {
        BuildActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Log log = Log.getSwingLog(MainFrame.this._configForm.getLogTextArea());
            try {
                if (!(MainFrame.this._saved && !MainFrame.this._configForm.isModified() || MainFrame.this.save())) {
                    return;
                }
                log.clear();
                ConfigPersister.getInstance().getConfig().checkInvariants();
                Builder b = new Builder(log);
                MainFrame.this._outfile = b.build();
                MainFrame.this.setRunEnabled(ConfigPersister.getInstance().getConfig().getHeaderType() == 0);
            }
            catch (InvariantViolationException ex) {
                MainFrame.this.setRunEnabled(false);
                ex.setBinding(MainFrame.this._configForm.getBinding(ex.getProperty()));
                MainFrame.this.warn(ex);
            }
            catch (BuilderException ex) {
                MainFrame.this.setRunEnabled(false);
                log.append(ex.getMessage());
            }
        }
    }

    private class RunActionListener
    implements ActionListener {
        RunActionListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent e) {
            try {
                try {
                    MainFrame.this.getGlassPane().setVisible(true);
                    Worker.post((Task)new Task(this){
                        final /* synthetic */ RunActionListener this$1;
                        {
                            this.this$1 = runActionListener;
                        }

                        public Object run() throws ExecException {
                            Log log = Log.getSwingLog(MainFrame.access$1(RunActionListener.access$0(this.this$1)).getLogTextArea());
                            log.clear();
                            String path = MainFrame.access$9(RunActionListener.access$0(this.this$1)).getPath();
                            if (Util.WINDOWS_OS) {
                                log.append("Executing: " + path);
                                Util.exec(path, log);
                            } else {
                                log.append("Jar integrity test, executing: " + path);
                                Util.exec("java -jar " + path, log);
                            }
                            return null;
                        }
                    });
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                MainFrame.this.getGlassPane().setVisible(false);
                throw throwable;
            }
            {
                Object var3_5 = null;
                MainFrame.this.getGlassPane().setVisible(false);
                return;
            }
        }

        static /* synthetic */ MainFrame access$0(RunActionListener runActionListener) {
            return runActionListener.MainFrame.this;
        }
    }

    private class AboutActionListener
    implements ActionListener {
        AboutActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            MainFrame.this.info("launch4j 2.0.RC3 :: Cross-platform Java application wrapper for creating Windows native executables\nCopyright (C) 2005 Grzegorz Kowal\nlaunch4j comes with ABSOLUTELY NO WARRANTY\nThis is free software, licensed under the GNU General Public License.\nThis product includes software developed by the Apache Software Foundation (http://www.apache.org/).\n\nThe following projects are used by launch4j...\n\nMinGW binutils (http://www.mingw.org/)\nCommons BeanUtils (http://jakarta.apache.org/commons/beanutils/)\nCommons Logging (http://jakarta.apache.org/commons/logging/)\nXStream (http://xstream.codehaus.org/)\nJGoodies Forms (http://www.jgoodies.com/freeware/forms/)\nJGoodies Looks (http://www.jgoodies.com/freeware/looks/)\nFoxtrot (http://foxtrot.sourceforge.net/)\nNuvola Icon Theme (http://www.icon-king.com)");
        }
    }
}

