/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.jrobin.core.XmlWriter;
import org.jrobin.graph.ValueMarker;

class ValueAxisUnit {
    private double gridStep = 2.0;
    private double labelStep = 10.0;

    ValueAxisUnit(double d, double d2) {
        this.gridStep = d;
        this.labelStep = d2;
    }

    double getGridStep() {
        return this.gridStep;
    }

    double getLabelStep() {
        return this.labelStep;
    }

    ValueMarker[] getValueMarkers(double d, double d2) {
        double d3;
        double d4 = 0.0;
        double d5 = 0.0;
        if (d > 0.0) {
            d4 = d;
            d3 = d % this.labelStep;
            d5 = d3 > 0.0 ? d + (this.labelStep - d3) : d;
        } else if (d < 0.0) {
            d4 = d;
            d3 = d % this.labelStep;
            d5 = Math.abs(d3) > 0.0 ? d - d3 : d;
        }
        ArrayList<ValueMarker> arrayList = new ArrayList<ValueMarker>();
        while (d4 <= d2 && d5 <= d2) {
            if (d4 < d5) {
                arrayList.add(new ValueMarker(d4, false));
                d4 = this.round(d4 + this.gridStep);
                continue;
            }
            if (d4 == d5) {
                arrayList.add(new ValueMarker(d5, true));
                d4 = this.round(d4 + this.gridStep);
                d5 = this.round(d5 + this.labelStep);
                continue;
            }
            arrayList.add(new ValueMarker(d5, true));
            d5 = this.round(d5 + this.labelStep);
        }
        while (d4 <= d2) {
            arrayList.add(new ValueMarker(d4, false));
            d4 = this.round(d4 + this.gridStep);
        }
        while (d5 <= d2) {
            arrayList.add(new ValueMarker(d5, true));
            d5 = this.round(d5 + this.labelStep);
        }
        return arrayList.toArray(new ValueMarker[0]);
    }

    double getNiceLower(double d) {
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = this.gridStep;
        double d5 = this.labelStep;
        while (d4 < 10.0) {
            d4 *= 10.0;
            d2 *= 10.0;
        }
        while (d5 < 10.0) {
            d5 *= 10.0;
            d3 *= 10.0;
        }
        int n = d > 0.0 ? 1 : -1;
        long l = new Double(d4).longValue();
        long l2 = new Double(d5).longValue();
        long l3 = new Double((double)n * d * d2).longValue();
        long l4 = new Double((double)n * d * d3).longValue();
        long l5 = l3 % l;
        long l6 = l4 % l2;
        if (d < 0.0) {
            if ((double)l6 > d5 * 0.5) {
                return (double)((long)n * l4 + l6 - l2) / d3;
            }
            if (l5 > 0L) {
                return (double)((long)n * l3 + l5 - l) / d2;
            }
            return (double)((long)n * l3 - l) / d2;
        }
        if ((double)l6 < d5 * 0.5) {
            return (double)((long)n * l4 - l6) / d3;
        }
        if (l5 > 0L) {
            return (double)((long)n * l3 - l5) / d2;
        }
        return (double)((long)n * l3) / d2;
    }

    double getNiceHigher(double d) {
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = this.gridStep;
        double d5 = this.labelStep;
        while (d4 < 10.0) {
            d4 *= 10.0;
            d2 *= 10.0;
        }
        while (d5 < 10.0) {
            d5 *= 10.0;
            d3 *= 10.0;
        }
        int n = d > 0.0 ? 1 : -1;
        long l = new Double(d4).longValue();
        long l2 = new Double(d5).longValue();
        long l3 = new Double((double)n * d * d2).longValue();
        long l4 = new Double((double)n * d * d3).longValue();
        long l5 = l3 % l;
        long l6 = l4 % l2;
        if (d < 0.0) {
            if ((double)l6 < d5 * 0.5) {
                return (double)((long)n * l4 + l6) / d3;
            }
            return (double)((long)n * l3 + l5) / d2;
        }
        if ((double)l6 > d5 * 0.5) {
            return (double)((long)n * l4 - l6 + l2) / d3;
        }
        return (double)((long)n * l3 - l5 + l) / d2;
    }

    private double round(double d) {
        return this.round(d, 14);
    }

    private double round(double d, int n) {
        return new BigDecimal(d).setScale(n, 6).doubleValue();
    }

    void exportXmlTemplate(XmlWriter xmlWriter) {
        xmlWriter.startTag("value_axis");
        xmlWriter.writeTag("grid_step", this.getGridStep());
        xmlWriter.writeTag("label_step", this.getLabelStep());
        xmlWriter.closeTag();
    }
}

