/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.synd.impl;

import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.feed.module.impl.ModuleUtils;
import com.sun.syndication.feed.synd.Converter;
import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndCategoryImpl;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndLink;
import com.sun.syndication.feed.synd.SyndLinkImpl;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.feed.synd.impl.ConverterForAtom03;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ConverterForAtom10
implements Converter {
    private String _type;

    public ConverterForAtom10() {
        this("atom_1.0");
    }

    protected ConverterForAtom10(String type) {
        this._type = type;
    }

    public String getType() {
        return this._type;
    }

    public void copyInto(WireFeed feed, SyndFeed syndFeed) {
        Date date;
        String rights;
        List authors;
        List aEntries;
        Feed aFeed = (Feed)feed;
        syndFeed.setModules(ModuleUtils.cloneModules(aFeed.getModules()));
        syndFeed.setEncoding(aFeed.getEncoding());
        syndFeed.setUri(aFeed.getId());
        syndFeed.setTitle(aFeed.getTitle());
        Content aSubtitle = aFeed.getSubtitle();
        if (aSubtitle != null) {
            syndFeed.setDescription(aSubtitle.getValue());
        }
        if (aFeed.getAlternateLinks() != null && aFeed.getAlternateLinks().size() == 1) {
            Link theLink = (Link)aFeed.getAlternateLinks().get(0);
            syndFeed.setLink(theLink.getHref());
        }
        ArrayList syndLinks = new ArrayList();
        if (aFeed.getAlternateLinks() != null && aFeed.getAlternateLinks().size() > 0) {
            syndLinks.addAll(this.createSyndLinks(aFeed.getAlternateLinks()));
        }
        if (aFeed.getOtherLinks() != null && aFeed.getOtherLinks().size() > 0) {
            syndLinks.addAll(this.createSyndLinks(aFeed.getOtherLinks()));
        }
        if ((aEntries = aFeed.getEntries()) != null) {
            syndFeed.setEntries(this.createSyndEntries(aFeed, aEntries));
        }
        if ((authors = aFeed.getAuthors()) != null && authors.size() > 0) {
            syndFeed.setAuthors(ConverterForAtom03.createSyndPersons(authors));
        }
        if ((rights = aFeed.getRights()) != null) {
            syndFeed.setCopyright(rights);
        }
        if ((date = aFeed.getUpdated()) != null) {
            syndFeed.setPublishedDate(date);
        }
    }

    protected List createSyndLinks(List aLinks) {
        ArrayList<SyndLinkImpl> sLinks = new ArrayList<SyndLinkImpl>();
        Iterator iter = aLinks.iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            SyndLinkImpl sLink = new SyndLinkImpl();
            sLink.setHref(link.getHref());
            sLink.setType(link.getType());
            sLink.setLength(link.getLength());
            sLink.setHreflang(link.getHref());
            sLinks.add(sLink);
        }
        return sLinks;
    }

    protected List createSyndEntries(Feed feed, List atomEntries) {
        ArrayList<SyndEntry> syndEntries = new ArrayList<SyndEntry>();
        for (int i = 0; i < atomEntries.size(); ++i) {
            syndEntries.add(this.createSyndEntry(feed, (Entry)atomEntries.get(i)));
        }
        return syndEntries;
    }

    protected SyndEntry createSyndEntry(Feed feed, Entry entry) {
        List categories;
        Date date;
        List authors;
        Content summary;
        SyndEntryImpl syndEntry = new SyndEntryImpl();
        syndEntry.setModules(ModuleUtils.cloneModules(entry.getModules()));
        syndEntry.setTitle(entry.getTitle());
        String id = entry.getId();
        if (id != null) {
            syndEntry.setUri(entry.getId());
        } else {
            syndEntry.setUri(syndEntry.getLink());
        }
        List contents = entry.getContents();
        if (contents != null && contents.size() > 0) {
            ArrayList<SyndContent> sContents = new ArrayList<SyndContent>();
            Iterator iter = contents.iterator();
            while (iter.hasNext()) {
                Content content = (Content)iter.next();
                sContents.add(this.createSyndContent(content));
            }
            syndEntry.setContents(sContents);
        }
        if ((summary = entry.getSummary()) != null) {
            syndEntry.setDescription(this.createSyndContent(entry.getSummary()));
        }
        if ((authors = entry.getAuthors()) != null && authors.size() > 0) {
            syndEntry.setAuthors(ConverterForAtom03.createSyndPersons(authors));
            SyndPerson person0 = (SyndPerson)syndEntry.getAuthors().get(0);
            syndEntry.setAuthor(person0.getName());
        }
        if ((date = entry.getPublished()) != null) {
            syndEntry.setPublishedDate(date);
        }
        if ((date = entry.getUpdated()) != null) {
            syndEntry.setUpdatedDate(date);
        }
        if ((categories = entry.getCategories()) != null) {
            ArrayList<SyndCategoryImpl> syndCategories = new ArrayList<SyndCategoryImpl>();
            Iterator iter = categories.iterator();
            while (iter.hasNext()) {
                Category c = (Category)iter.next();
                SyndCategoryImpl syndCategory = new SyndCategoryImpl();
                syndCategory.setName(c.getTerm());
                syndCategory.setTaxonomyUri(c.getScheme());
                syndCategories.add(syndCategory);
            }
            syndEntry.setCategories(syndCategories);
        }
        if (entry.getAlternateLinks() != null && entry.getAlternateLinks().size() == 1) {
            Link theLink = (Link)entry.getAlternateLinks().get(0);
            syndEntry.setLink(theLink.getHref());
        }
        ArrayList syndLinks = new ArrayList();
        if (entry.getAlternateLinks() != null && entry.getAlternateLinks().size() > 0) {
            syndLinks.addAll(this.createSyndLinks(entry.getAlternateLinks()));
        }
        if (entry.getOtherLinks() != null && entry.getOtherLinks().size() > 0) {
            syndLinks.addAll(this.createSyndLinks(entry.getOtherLinks()));
        }
        syndEntry.setLinks(syndLinks);
        return syndEntry;
    }

    public SyndLink createSyndLink(Feed feed, Entry entry, Link link) {
        SyndLinkImpl syndLink = new SyndLinkImpl();
        syndLink.setRel(link.getRel());
        syndLink.setType(link.getType());
        syndLink.setHref(link.getHref());
        syndLink.setHreflang(link.getHreflang());
        syndLink.setLength(link.getLength());
        return syndLink;
    }

    public WireFeed createRealFeed(SyndFeed syndFeed) {
        List authors;
        String sDesc;
        Feed aFeed = new Feed(this.getType());
        aFeed.setModules(ModuleUtils.cloneModules(syndFeed.getModules()));
        aFeed.setEncoding(syndFeed.getEncoding());
        aFeed.setId(syndFeed.getUri());
        aFeed.setTitle(syndFeed.getTitle());
        ArrayList<Link> alternateLinks = new ArrayList<Link>();
        ArrayList<Link> otherLinks = new ArrayList<Link>();
        String sLink = syndFeed.getLink();
        List slinks = syndFeed.getLinks();
        if (slinks != null) {
            Iterator iter = slinks.iterator();
            while (iter.hasNext()) {
                SyndLink syndLink = (SyndLink)iter.next();
                Link link = new Link();
                link.setRel(syndLink.getRel());
                link.setHref(syndLink.getHref());
                link.setHreflang(syndLink.getHreflang());
                link.setLength(syndLink.getLength());
                if (link.getRel() == null || "".equals(link.getRel().trim()) || "alternate".equals(syndLink.getRel())) {
                    alternateLinks.add(link);
                    continue;
                }
                otherLinks.add(link);
            }
        }
        if (alternateLinks.size() == 0 && syndFeed.getLink() != null) {
            Link link = new Link();
            link.setRel("alternate");
            link.setHref(syndFeed.getLink());
            alternateLinks.add(link);
        }
        if (alternateLinks.size() > 0) {
            aFeed.setAlternateLinks(alternateLinks);
        }
        if (otherLinks.size() > 0) {
            aFeed.setOtherLinks(otherLinks);
        }
        List sCats = syndFeed.getCategories();
        ArrayList<Category> aCats = new ArrayList<Category>();
        if (sCats != null) {
            Iterator iter = sCats.iterator();
            while (iter.hasNext()) {
                SyndCategory sCat = (SyndCategory)iter.next();
                Category aCat = new Category();
                aCat.setTerm(sCat.getName());
                aCat.setScheme(sCat.getTaxonomyUri());
                aCats.add(aCat);
            }
        }
        if (aCats.size() > 0) {
            aFeed.setCategories(aCats);
        }
        if ((sDesc = syndFeed.getDescription()) != null) {
            Content subtitle = new Content();
            subtitle.setType("text");
            subtitle.setValue(sDesc);
            aFeed.setSubtitle(subtitle);
        }
        if ((authors = syndFeed.getAuthors()) != null && authors.size() > 0) {
            aFeed.setAuthors(ConverterForAtom03.createAtomPersons(authors));
        }
        aFeed.setRights(syndFeed.getCopyright());
        aFeed.setUpdated(syndFeed.getPublishedDate());
        List sEntries = syndFeed.getEntries();
        if (sEntries != null) {
            aFeed.setEntries(this.createAtomEntries(sEntries));
        }
        return aFeed;
    }

    protected SyndContent createSyndContent(Content content) {
        SyndContentImpl sContent = new SyndContentImpl();
        sContent.setType(content.getType());
        sContent.setValue(content.getValue());
        return sContent;
    }

    protected List createAtomEntries(List syndEntries) {
        ArrayList<Entry> atomEntries = new ArrayList<Entry>();
        for (int i = 0; i < syndEntries.size(); ++i) {
            atomEntries.add(this.createAtomEntry((SyndEntry)syndEntries.get(i)));
        }
        return atomEntries;
    }

    protected Content createAtomContent(SyndContent sContent) {
        Content content = new Content();
        content.setType(sContent.getType());
        content.setValue(sContent.getValue());
        return content;
    }

    protected List createAtomContents(List syndContents) {
        ArrayList<Content> atomContents = new ArrayList<Content>();
        for (int i = 0; i < syndContents.size(); ++i) {
            atomContents.add(this.createAtomContent((SyndContent)syndContents.get(i)));
        }
        return atomContents;
    }

    protected Entry createAtomEntry(SyndEntry sEntry) {
        SyndContent sDescription;
        Entry aEntry = new Entry();
        aEntry.setModules(ModuleUtils.cloneModules(sEntry.getModules()));
        aEntry.setId(sEntry.getUri());
        aEntry.setTitle(sEntry.getTitle());
        ArrayList<Link> alternateLinks = new ArrayList<Link>();
        ArrayList<Link> otherLinks = new ArrayList<Link>();
        List slinks = sEntry.getLinks();
        if (slinks != null) {
            Iterator iter = slinks.iterator();
            while (iter.hasNext()) {
                SyndLink syndLink = (SyndLink)iter.next();
                Link link = new Link();
                link.setRel(syndLink.getRel());
                link.setHref(syndLink.getHref());
                link.setHreflang(syndLink.getHreflang());
                link.setLength(syndLink.getLength());
                link.setType(syndLink.getType());
                if (link.getRel() == null || "".equals(link.getRel().trim()) || "alternate".equals(syndLink.getRel())) {
                    alternateLinks.add(link);
                    continue;
                }
                otherLinks.add(link);
            }
        }
        if (alternateLinks.size() == 0 && sEntry.getLink() != null) {
            Link link = new Link();
            link.setRel("alternate");
            link.setHref(sEntry.getLink());
            alternateLinks.add(link);
        }
        if (alternateLinks.size() > 0) {
            aEntry.setAlternateLinks(alternateLinks);
        }
        if (otherLinks.size() > 0) {
            aEntry.setOtherLinks(otherLinks);
        }
        List sCats = sEntry.getCategories();
        ArrayList<Category> aCats = new ArrayList<Category>();
        if (sCats != null) {
            Iterator iter = sCats.iterator();
            while (iter.hasNext()) {
                SyndCategory sCat = (SyndCategory)iter.next();
                Category aCat = new Category();
                aCat.setTerm(sCat.getName());
                aCat.setScheme(sCat.getTaxonomyUri());
                aCats.add(aCat);
            }
        }
        if (aCats.size() > 0) {
            aEntry.setCategories(aCats);
        }
        if ((sDescription = sEntry.getDescription()) != null) {
            Content summary = new Content();
            summary.setType(sDescription.getType());
            summary.setValue(sDescription.getValue());
            aEntry.setSummary(summary);
        }
        List syndContents = sEntry.getContents();
        aEntry.setContents(this.createAtomContents(syndContents));
        ArrayList<Person> authors = sEntry.getAuthors();
        if (authors != null && authors.size() > 0) {
            aEntry.setAuthors(ConverterForAtom03.createAtomPersons(authors));
        } else if (sEntry.getAuthor() != null) {
            Person person = new Person();
            person.setName(sEntry.getAuthor());
            authors = new ArrayList<Person>();
            authors.add(person);
            aEntry.setAuthors(authors);
        }
        aEntry.setPublished(sEntry.getPublishedDate());
        aEntry.setUpdated(sEntry.getUpdatedDate());
        return aEntry;
    }
}

