AC_DEFUN(IRCG_SOCKADDR_STORAGE,[
AC_CACHE_CHECK([wether sockaddr_storage is available], ac_cv_sockaddr_storage, [
  AC_TRY_COMPILE([
#include <sys/types.h>
#include <sys/socket.h>
], [
struct sockaddr_storage x;
],[
  ac_cv_sockaddr_storage=yes
],[
  ac_cv_sockaddr_storage=no
])
])
if test "$ac_cv_sockaddr_storage" = "no"; then
  AC_DEFINE(IRCG_DEFINE_SOCKADDR_STORAGE, 1, [Whether we need to define our own sockaddr_storage])
fi
])

dnl IRCG_CONFIG_NICE(filename)
dnl Puts the configure options into a convenient shell script
AC_DEFUN(IRCG_CONFIG_NICE,[
if test -z "$no_recursion"; then
  rm -f $1
  cat >$1<<EOF
#! /bin/sh
#
# Created by configure

EOF

  for var in CFLAGS CXXFLAGS CPPFLAGS LDFLAGS LIBS; do
    eval val="\$$var"
    if test -n "$val"; then
      eval echo "$var=\'$val\' \\\\" >> $1
    fi
  done
    
  for arg in [$]0 "[$]@"; do
    echo "'[$]arg' \\" >> $1
  done
  echo '"[$]@"' >> $1
  chmod +x $1
fi
])

AC_DEFUN(IRCG_ARG_ST,[
AC_ARG_WITH(st,
[  --with-st=DIR           The prefix of SGI's State Threads Library],
[
  if test -r "$withval/include/st.h"; then
    CPPFLAGS="$CPPFLAGS -I$withval/include"
    LDFLAGS="$LDFLAGS -L$withval/lib"
  elif test -r "$withval/st.h"; then
    CPPFLAGS="$CPPFLAGS -I$withval"
    LDFLAGS="$LDFLAGS -L$withval"
  fi
])
AC_CHECK_HEADERS(st.h,[ ],[
  AC_MSG_ERROR([Sorry[,] I was unable to locate the State Threads header file.  Please specify the prefix using --with-st=/prefix])
])
LIBS="$LIBS -lst"
])
