/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_connect.c,v 1.12.2.2 2001/08/01 07:51:47 sas Exp $ */


#include <st.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/un.h>
#include <string.h>
#include "if_irc.h"

#include "irc_private.h"

static int set_conn_details(irconn_t *conn, const char *server, int port)
{
	if (server[0] != '/') {
		struct sockaddr_in *s_in = (struct sockaddr_in *) &conn->server;	
		
		if (!inet_aton(server, &s_in->sin_addr))
			return -1;
		s_in->sin_port = htons(port);
		s_in->sin_family = AF_INET;
		conn->server_len = sizeof(*s_in);
		conn->sockpf = PF_INET;
		return 0;
	} else {
		struct sockaddr_un *s_un = (struct sockaddr_un *) &conn->server;
		
		s_un->sun_family = AF_UNIX;
		if (strlen(server) + 1 >= sizeof(s_un->sun_path))
			return -1;
		strcpy(s_un->sun_path, server);
		conn->server_len = sizeof(*s_un);
#ifndef PF_LOCAL
#define PF_LOCAL PF_UNIX
#endif
		conn->sockpf = PF_LOCAL;
		return 0;
	}
	return -1;
}

int irc_connect(const char *username, register_hooks_t hooks,
		void *data, const char *server,
		int port, irconn_t *conn)
{
	if (set_conn_details(conn, server, port))
		return -1;
	
	conn->status = 0;
	conn->msg_buffer.c = NULL;
	SLIST_INIT(&conn->channels);
	SLIST_INIT(&conn->ignore);
	
	conn->username_len = strlen(username);
	if (conn->username_len >= MAX_USERNAME_LEN) 
		conn->username_len = MAX_USERNAME_LEN - 1; 
	memcpy((void *) conn->username, username, conn->username_len + 1);	
	memset(conn->hooks, 0, sizeof(void *) * IRCG_NR_HOOKS);
#define DEFAULT_IDENT "ircg"
#define DEFAULT_REALNAME "http://schumann.cx/ircg/"
	memcpy(conn->ident, DEFAULT_IDENT, sizeof(DEFAULT_IDENT));
	conn->password[0] = '\0';
	memcpy(conn->realname, DEFAULT_REALNAME, sizeof(DEFAULT_REALNAME));
	
	hooks(conn, data);

	conn->data = data;
	
	conn->dispatcher = st_thread_create(irc_dispatcher, conn, 0, 4000);

	return 0;
}
