/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_ignore.c,v 1.3 2001/04/22 18:13:11 sas Exp $ */


#include <stdlib.h>
#include <string.h>

#include "php_smart_str.h"

#include "if_irc.h"

int irc_ignore_add(irconn_t *conn, smart_str *who, int count)
{
	struct irc_ignore *m;
	int i;

	for (i = 0; i < count; i++) {
		m = malloc(sizeof *m);
		m->who.c = NULL;
		smart_str_append(&m->who, &who[i]);
		
		SLIST_INSERT_HEAD(&conn->ignore, m, next);
	}

	return 0;
}

int irc_ignore_destroy(irconn_t *conn)
{
	struct irc_ignore *m, *next;

	for (m = SLIST_FIRST(&conn->ignore);
			m;
			m = next) {
		next = SLIST_NEXT(m, next);
		smart_str_free(&m->who);
		free(m);
	}	
	SLIST_INIT(&conn->ignore);

	return 0;
}

int irc_ignore_check(irconn_t *conn, smart_str *who)
{
	int ret = 0;
	struct irc_ignore *m, *next;

	for (m = SLIST_FIRST(&conn->ignore); 
			m;
			m = next) {
		next = SLIST_NEXT(m, next);
		
		if (who->len == m->who.len && 
				strncasecmp(who->c, m->who.c, who->len) == 0)
			break;
	}
	
	if (m) {
		ret = 1;
	}

	return ret;
}

int irc_ignore_del(irconn_t *conn, smart_str *who)
{
	int ret = -1;
	struct irc_ignore *m, *next;

	for (m = SLIST_FIRST(&conn->ignore); 
			m;
			m = next) {
		next = SLIST_NEXT(m, next);
		
		if (who->len == m->who.len && 
				strncasecmp(who->c, m->who.c, who->len) == 0)
			break;
	}

	if (m) {
		ret = 0;
		smart_str_free(&m->who);
		SLIST_REMOVE(&conn->ignore, m, irc_ignore, next);
		free(m);
	}

	return ret;
}
