/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_join.c,v 1.5.2.1 2001/08/01 07:45:16 sas Exp $ */

#include <string.h>
#include <stdlib.h>

#include "if_irc.h"
#include "irc_private.h"

struct chan_head ircg_free_chan_list; 

int irc_join(irconn_t *conn,
		const char *channel,
		const char *key,
		void *data)
{
	irc_chan_t *result;
	size_t len;

	result = SLIST_FIRST(&ircg_free_chan_list);
	if (!result)	
		result = malloc(sizeof(*result));
	else
		SLIST_REMOVE_HEAD(&ircg_free_chan_list, next);

	SLIST_INSERT_HEAD(&conn->channels, result, next);

	len = strlen(channel);
	if (len >= MAX_CHANNEL_LEN) len = MAX_CHANNEL_LEN - 1;
	memcpy((void *) result->channel, channel, len + 1);	
	result->channel_len = len;
	result->data = data;

	irc_send_message(conn, "JOIN", key ? 2 : 1, channel, key);
	
	return 0;
}
