/* Generated by re2c 0.5 on Sun Mar 11 12:18:05 2001 */
#line 1 "irc_msg_scanner.re"
/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_msg_scanner.c,v 1.7 2001/03/11 11:19:13 sas Exp $ */

#include <sys/types.h>
#include <string.h>
#include <stdio.h>

#include "php_smart_str.h"
#include "if_irc.h"
#include "irc_private.h"

#line 58


enum {
	STATE_FROM,
	STATE_COMMAND,
	STATE_PARAMS
};

#ifdef DEBUG
#define scdebug(a) printf a
#else
#define scdebug(a)
#endif

#define YYFILL(n) { }
#define YYCTYPE unsigned char
#define YYCURSOR xp
#define YYLIMIT end
#define YYMARKER q
#define STATE state
#define NSTATE(n) scdebug(("Switching to " #n " %d was %d\n", STATE_##n, state)); STATE = STATE_##n; continue

#define HANDLE_NICKNAME { \
	char *p; \
	p = strchr(start, '!'); \
	if (p) {\
		smart_str_setl(&msg->nickname, start + 1, p - start - 1); \
		msg->nickname.c[msg->nickname.len] = '\0'; \
	} \
}

#define HANDLE_SERVERNAME 

#define HANDLE_COMMAND {\
	smart_str_setl(&msg->cmd, start, YYCURSOR - start); \
	msg->cmd.c[msg->cmd.len] = '\0'; \
	scdebug(("COMMAND(%s)\n", msg->cmd.c)); \
}

#define HANDLE_MSG(skip) { \
	if (msg->nr_para < IRCMSG_MAX_PARA) { \
	smart_str_setl(&msg->para[msg->nr_para], start + skip + 1, \
			YYCURSOR - start - skip - 1); \
	msg->para[msg->nr_para].c[msg->para[msg->nr_para].len] = '\0'; \
	scdebug(("PARA(%s)\n", msg->para[msg->nr_para].c)); \
	msg->nr_para++; \
	} \
}

#define HANDLE_CRLF { \
	goto stop; \
}

int irc_scan_message(const char *buf, size_t n, ircmsg_t *msg) {
	int ret = -1;
	int state = STATE_FROM;
	const char *end, *q = NULL;
	const char *xp;
	const char *start;

	msg->nr_para = 0;
	
	YYCURSOR = buf;
	YYLIMIT = buf + n;

	while (YYCURSOR < YYLIMIT) {
		start = YYCURSOR;

		scdebug(("state %d, %s'\n", STATE, YYCURSOR));
		switch (STATE) {
		case STATE_FROM:
{
	YYCTYPE yych;
	unsigned int yyaccept;
	static unsigned char yybm[] = {
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128,   0, 128, 128,   0, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 240, 144, 128, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 144, 128, 128, 128, 128, 128, 
	  0, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 192, 192, 192, 192, 240, 
	128, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 192, 192, 192, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	};
	goto yy0;
yy1:	++YYCURSOR;
yy0:
	if((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if(yych != ':')	goto yy4;
yy2:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yych <= 'Z'){
		if(yych <= '/'){
			if(yych <= ',')	goto yy3;
			if(yych <= '.')	goto yy5;
		} else {
			if(yych <= ':')	goto yy5;
			if(yych >= 'A')	goto yy8;
		}
	} else {
		if(yych <= '`'){
			if(yych <= '^')	goto yy10;
			if(yych <= '_')	goto yy8;
		} else {
			if(yych <= 'z')	goto yy8;
			if(yych <= '}')	goto yy10;
		}
	}
yy3:
#line 132
	{ YYCURSOR--; NSTATE(COMMAND); }
yy4:	yych = *++YYCURSOR;
	goto yy3;
yy5:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy6:	if(yybm[0+yych] & 16)	goto yy5;
yy7:
#line 131
	{ HANDLE_SERVERNAME; NSTATE(COMMAND); }
yy8:	yyaccept = 1;
	YYMARKER = ++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy9:	if(yybm[0+yych] & 32)	goto yy8;
	if(yych <= '/'){
		if(yych <= '!'){
			if(yych <= ' ')	goto yy7;
			goto yy13;
		} else {
			if(yych == '.')	goto yy5;
			goto yy7;
		}
	} else {
		if(yych <= '_'){
			if(yych <= ':')	goto yy5;
			if(yych <= 'Z')	goto yy7;
		} else {
			if(yych <= '`')	goto yy7;
			if(yych >= '~')	goto yy7;
		}
	}
yy10:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy11:	if(yybm[0+yych] & 64)	goto yy10;
	if(yych == '!')	goto yy13;
yy12:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 1:	goto yy7;
	case 0:	goto yy3;
	}
yy13:	yych = *++YYCURSOR;
	if(yych == '@')	goto yy12;
	goto yy15;
yy14:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy15:	if(yybm[0+yych] & 128)	goto yy14;
	if(yych <= '?')	goto yy12;
yy16:	yych = *++YYCURSOR;
	if(yych <= '@'){
		if(yych <= '.'){
			if(yych <= ',')	goto yy12;
		} else {
			if(yych <= '/')	goto yy12;
			if(yych >= ';')	goto yy12;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy17;
			if(yych <= '^')	goto yy12;
		} else {
			if(yych <= '`')	goto yy12;
			if(yych >= '{')	goto yy12;
		}
	}
yy17:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy18:	if(yych <= '@'){
		if(yych <= '.'){
			if(yych >= '-')	goto yy17;
		} else {
			if(yych <= '/')	goto yy19;
			if(yych <= ':')	goto yy17;
		}
	} else {
		if(yych <= '_'){
			if(yych <= 'Z')	goto yy17;
			if(yych >= '_')	goto yy17;
		} else {
			if(yych <= '`')	goto yy19;
			if(yych <= 'z')	goto yy17;
		}
	}
yy19:
#line 130
	{ HANDLE_NICKNAME; NSTATE(COMMAND); }
}
#line 133

			break;
		
		case STATE_COMMAND:
{
	YYCTYPE yych;
	unsigned int yyaccept;
	static unsigned char yybm[] = {
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	goto yy20;
yy21:	++YYCURSOR;
yy20:
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if(yybm[0+yych] & 128)	goto yy23;
	if(yych <= '\000')	goto yy26;
	if(yych == ' ')	goto yy26;
yy22:yy23:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy24:	if(yybm[0+yych] & 128)	goto yy23;
yy25:
#line 138
	{ HANDLE_COMMAND; ret = 0; NSTATE(PARAMS); }
yy26:	yych = *++YYCURSOR;
yy27:
#line 139
	{ continue; }
}
#line 140

			break;
		
		case STATE_PARAMS:
{
	YYCTYPE yych;
	unsigned int yyaccept;
	static unsigned char yybm[] = {
	  0, 192, 192, 192, 192, 192, 192, 192, 
	192, 192,   0, 192, 192,   0, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	128, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 128, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	};
	goto yy28;
yy29:	++YYCURSOR;
yy28:
	if((YYLIMIT - YYCURSOR) < 3) YYFILL(3);
	yych = *YYCURSOR;
	if(yych <= '\f'){
		if(yych <= '\000')	goto yy30;
		if(yych == '\n')	goto yy32;
		goto yy34;
	} else {
		if(yych <= '\r')	goto yy32;
		if(yych != ' ')	goto yy34;
	}
yy30:	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if(yybm[0+yych] & 64)	goto yy35;
	if(yych >= ':')	goto yy38;
yy31:
#line 148
	{ continue; }
yy32:	yych = *++YYCURSOR;
yy33:
#line 147
	{ HANDLE_CRLF; }
yy34:	yych = *++YYCURSOR;
	goto yy31;
yy35:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy36:	if(yybm[0+yych] & 64)	goto yy35;
yy37:
#line 146
	{ HANDLE_MSG(0); continue; }
yy38:	yych = *++YYCURSOR;
	if(yybm[0+yych] & 128)	goto yy40;
yy39:	YYCURSOR = YYMARKER;
	switch(yyaccept){
	case 0:	goto yy31;
	}
yy40:	++YYCURSOR;
	if(YYLIMIT == YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy41:	if(yybm[0+yych] & 128)	goto yy40;
yy42:
#line 145
	{ HANDLE_MSG(1); continue; }
}
#line 149

			break;
		}
	}
stop:

	return ret;
}

#if 0 

int main(int argc, char **argv) {
	ircmsg_t msg;
	int i;

	memset(&msg, 0, sizeof(msg));
	irc_scan_message(argv[1], strlen(argv[1]), &msg);
	printf("%s\n", msg.nickname.c);
	printf("%s\n", msg.cmd.c);
	for (i = 0; i < msg.nr_para; i++)
		printf("%s\n", msg.para[i].c);
}

#endif
