/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_msg_scanner.re,v 1.5 2001/03/11 11:19:13 sas Exp $ */

#include <sys/types.h>
#include <string.h>
#include <stdio.h>

#include "php_smart_str.h"
#include "if_irc.h"
#include "irc_private.h"

/*!re2c
any = [\000-\377];
letter = [a-zA-Z];
special = [_^{|}];
nickname = [a-zA-Z_^{}|[\]\\] [a-zA-Z_^{}|0-9-[\]\\]*;
badchars = [\000\012\015\040\100];
user = (any\badchars)+;
host = [:.a-zA-Z0-9_-]+;
servername = host;
command = [A-Z0-9:]+;
crlf = [\012\015];
msg = (any\[\012\015\000])+;
middle = (any\[\000\012\015\040\072])+;
space = [\000\040];
*/

enum {
	STATE_FROM,
	STATE_COMMAND,
	STATE_PARAMS
};

#ifdef DEBUG
#define scdebug(a) printf a
#else
#define scdebug(a)
#endif

#define YYFILL(n) { }
#define YYCTYPE unsigned char
#define YYCURSOR xp
#define YYLIMIT end
#define YYMARKER q
#define STATE state
#define NSTATE(n) scdebug(("Switching to " #n " %d was %d\n", STATE_##n, state)); STATE = STATE_##n; continue

#define HANDLE_NICKNAME { \
	char *p; \
	p = strchr(start, '!'); \
	if (p) {\
		smart_str_setl(&msg->nickname, start + 1, p - start - 1); \
		msg->nickname.c[msg->nickname.len] = '\0'; \
	} \
}

#define HANDLE_SERVERNAME 

#define HANDLE_COMMAND {\
	smart_str_setl(&msg->cmd, start, YYCURSOR - start); \
	msg->cmd.c[msg->cmd.len] = '\0'; \
	scdebug(("COMMAND(%s)\n", msg->cmd.c)); \
}

#define HANDLE_MSG(skip) { \
	if (msg->nr_para < IRCMSG_MAX_PARA) { \
	smart_str_setl(&msg->para[msg->nr_para], start + skip + 1, \
			YYCURSOR - start - skip - 1); \
	msg->para[msg->nr_para].c[msg->para[msg->nr_para].len] = '\0'; \
	scdebug(("PARA(%s)\n", msg->para[msg->nr_para].c)); \
	msg->nr_para++; \
	} \
}

#define HANDLE_CRLF { \
	goto stop; \
}

int irc_scan_message(const char *buf, size_t n, ircmsg_t *msg) {
	int ret = -1;
	int state = STATE_FROM;
	const char *end, *q = NULL;
	const char *xp;
	const char *start;

	msg->nr_para = 0;
	
	YYCURSOR = buf;
	YYLIMIT = buf + n;

	while (YYCURSOR < YYLIMIT) {
		start = YYCURSOR;

		scdebug(("state %d, %s'\n", STATE, YYCURSOR));
		switch (STATE) {
		case STATE_FROM:
/*!re2c
  ":" nickname "!" user "@" host	{ HANDLE_NICKNAME; NSTATE(COMMAND); }
  ":" servername					{ HANDLE_SERVERNAME; NSTATE(COMMAND); }
  any								{ YYCURSOR--; NSTATE(COMMAND); }
*/
			break;
		
		case STATE_COMMAND:
/*!re2c
  command							{ HANDLE_COMMAND; ret = 0; NSTATE(PARAMS); }
  space								{ continue; }
*/
			break;
		
		case STATE_PARAMS:
/*!re2c
  space [:] msg							{ HANDLE_MSG(1); continue; }
  space middle							{ HANDLE_MSG(0); continue; }
  crlf									{ HANDLE_CRLF; }
  any									{ continue; }
*/
			break;
		}
	}
stop:

	return ret;
}

#if 0 

int main(int argc, char **argv) {
	ircmsg_t msg;
	int i;

	memset(&msg, 0, sizeof(msg));
	irc_scan_message(argv[1], strlen(argv[1]), &msg);
	printf("%s\n", msg.nickname.c);
	printf("%s\n", msg.cmd.c);
	for (i = 0; i < msg.nr_para; i++)
		printf("%s\n", msg.para[i].c);
}

#endif
