/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_tool.c,v 1.5.2.2 2001/08/01 07:49:17 sas Exp $ */

#include <stdarg.h>
#include <unistd.h>
#include <string.h>
#include <st.h>
#include "php_smart_str.h"
#include "if_irc.h"
#include "irc_private.h"

extern int ircg_log_opt;

static void irc_send_message_intern(irconn_t *conn, int status, const char *cmd, int nr, va_list ap)
{
	smart_str l = {0};
	int i;
	const char *arg;

	smart_str_appends(&l, cmd);
	
	for (i = 0; i < nr; i++) {
		smart_str_appendc(&l, ' ');
		if (i == nr - 1) {
			smart_str_appendc(&l, ':');
		}
		arg = va_arg(ap, const char *);
		smart_str_appends(&l, arg);
	}

	smart_str_appendl(&l, "\r\n", 2);
	if (ircg_log_opt & 16) {
		write(1, "SEND(", 5);
		write(1, conn->username, conn->username_len);
		write(1, "):", 2);
		write(1, l.c, l.len);
	}
	if (conn->status < status || !conn->c) {
		smart_str_appendl(&conn->msg_buffer, l.c, l.len);
		if (ircg_log_opt & 16)
			write(1, "..delayed\n", sizeof("..delayed\n") - 1);
	} else {
		if (st_write(conn->c, l.c, l.len, 0) == -1)
			irc_disconnect(conn, "st_write failed");
	}
	smart_str_free(&l);
}

void irc_send_message_ex(irconn_t *conn, int status, const char *cmd, int nr, ...)
{
	va_list ap;
	va_start(ap, nr);
	irc_send_message_intern(conn, status, cmd, nr, ap);
	va_end(ap);
}

void irc_send_message(irconn_t *conn, const char *cmd, int nr, ...) 
{
	va_list ap;
	va_start(ap, nr);
	irc_send_message_intern(conn, 1, cmd, nr, ap);
	va_end(ap);
}

irc_chan_t *irc_locate_channel(irconn_t *conn, const char *name)
{
	irc_chan_t *ep;

	SLIST_FOREACH(ep, &conn->channels, next) {
		if (!strcasecmp(ep->channel, name)) {
			return ep;
		}
	}
	return NULL;
}
