/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: irc_write_buffer.h,v 1.13.2.1 2001/08/01 08:48:17 sas Exp $ */

#ifndef IRC_WRITE_BUFFER_H
#define IRC_WRITE_BUFFER_H


#include "queue.h"
#include "php_smart_str_public.h"

struct irc_bucket {
	smart_str buf;
	STAILQ_ENTRY(irc_bucket) next;
	SLIST_ENTRY(irc_bucket) fnext;
};

typedef struct write_buf {
	int fd;
	unsigned int bsize;
	char queued;
	char dead;
	char blocked;
	STAILQ_HEAD(irc_bucket_head, irc_bucket) brigade;
	LIST_ENTRY(write_buf) next;
} irc_write_buf;

void irc_write_buf_add(irc_write_buf *buf, int fd);
void irc_write_buf_del(irc_write_buf *buf);
#define irc_write_buf_append(a,b) irc_write_buf_append_ex(a,b,1)
int irc_write_buf_append_ex(irc_write_buf *buf, smart_str *data, int copy);
void irc_write_buf_flush(irc_write_buf *buf);

#endif
