/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: main.c,v 1.7 2001/04/22 18:13:11 sas Exp $ */

#include <signal.h>
#include <stdlib.h>

#include "if_irc.h"

#define SERVER "0"
#define PORT 6667

static void on_connect(irconn_t *conn, void *dummy)
{
	irc_join(conn, "#Funweb", NULL, NULL);
}

static void register_hooks(irconn_t *conn, void *dummy)
{
	irc_register_hook(conn, IRCG_CONNECT, on_connect);
}

int main(void) {
	irconn_t c, d, e;

	st_init();
	signal(SIGPIPE, SIG_IGN);
	irc_connect("Sascha2", register_hooks, NULL, SERVER, PORT, &c);
	irc_connect("fooman", register_hooks, NULL, SERVER, PORT, &d);
	irc_connect("jesus", register_hooks, NULL, SERVER, PORT, &e);
	st_sleep(10);

	irc_disconnect(&c, "Hiho!");
	exit(0);
}
