/*
 * Copyright (c) 2000-2001, Sascha Schumann. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.  
 * 
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the
 * distribution. 
 * 
 * Neither the name of Sascha Schumann nor the names of his contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

/* $Id: php_smart_str.h,v 1.6 2001/04/03 19:33:33 sas Exp $ */

#ifndef PHP_SMART_STR_H
#define PHP_SMART_STR_H

#include <stdlib.h>
#include <string.h>

#include "php_smart_str_public.h"

#define smart_str_0(x) ((x)->c[(x)->len] = '\0')

extern unsigned long long smart_str_allocated_bytes;

#define smart_str_alloc(d,n) {\
	if (!d->c) d->len = d->a = 0; \
	if (n >= d->a) {\
		smart_str_allocated_bytes -= d->a; \
		d->c = realloc(d->c, n + 12); \
		d->a = n + 11; \
		smart_str_allocated_bytes += d->a; \
	}\
}

#define smart_str_appends(dest, src) smart_str_appendl(dest, src, strlen(src))

static inline void smart_str_appendc(smart_str *dest, char c)
{
	++dest->len;
	smart_str_alloc(dest, dest->len);
	dest->c[dest->len - 1] = c;
}

static inline void smart_str_free(smart_str *s)
{
	if (s->c) {
		smart_str_allocated_bytes -= s->a;
		free(s->c);
		s->c = NULL;
	}
	s->a = s->len = 0;
}

static inline void smart_str_appendl(smart_str *dest, const char *src, size_t len)
{
	size_t newlen;

	newlen = dest->c ? dest->len + len : len;
	smart_str_alloc(dest, newlen);
	memcpy(dest->c + dest->len, src, len);
	dest->len = newlen;
}

static inline void smart_str_append(smart_str *dest, smart_str *src)
{
	smart_str_appendl(dest, src->c, src->len);
}

static inline void smart_str_setl(smart_str *dest, const char *src, size_t len)
{
	dest->len = len;
	dest->a = len + 1;
	dest->c = (char *) src;
}

static inline void smart_str_sets(smart_str *dest, const char *src)
{
	smart_str_setl(dest, src, strlen(src));
}

#endif
