/* Simple wrapper for rijndael algorithm
 *
 * Copyright (C) 2003  Martin J. Muench <mjm@codito.de>
 */

#include "config.h"
#include "cipherwrap.h"
#include "wrap.h"
#include "sha256.h"

void
Getpass(unsigned char *key, size_t maxlen)
{
  SHA256Context shastruct;
  unsigned char hash[SHA256_HASH_SIZE];
  const char *buf=getpass(">>> Enter password: ");

  SHA256Init (&shastruct);
  SHA256Update (&shastruct, buf, strlen(buf));
  SHA256Final (&shastruct, hash);

  /* burn buffer */
  memset(&buf, 0, strlen(buf));

  memset(key, 0x00, maxlen);
  memcpy(key, hash, maxlen);
}

bool 
encipher_string(const unsigned char* key,
		unsigned char * cipher_text,
		const char * plain_text,
		...)
{
  struct cfb_aes_context* ctx = init(key, RIJNDAEL256_KEYSIZE);
  char buffer[CIPHERBUF], textbuf[CIPHERBUF];
  va_list ap;

  if(!ctx)                       
    return false;

  memset(cipher_text, 0, CIPHERBUF);

  memset(textbuf, 0, sizeof(textbuf));
  va_start(ap, plain_text);
  vsnprintf(textbuf, sizeof(textbuf)-1, (char *)plain_text, ap);
  va_end(ap);
  
  /* Copy session ID before buffer */
  memset(buffer, 0, sizeof(buffer));
  assert(strlen(SID) < sizeof(buffer)-1);
  strncpy(buffer, SID, strlen(SID));
  assert(strlen(textbuf) < sizeof(buffer)-strlen(buffer));
  strncat(buffer, textbuf, strlen(textbuf));
  assert(strlen(buffer) <= CIPHERBUF);

  /* encipher */
  if(!cfb_encrypt(ctx, cipher_text, (unsigned char *)buffer, CIPHERBUF)) {
    clear_ctx(ctx);
    return false;
  }

  clear_ctx(ctx);

  return(cipher_text[0] == 0x00 ? false : true);
}

bool 
decipher_string(const unsigned char* key,
		unsigned char * decipher_text,
		const unsigned char * cipher_text)
{
  struct cfb_aes_context* ctx = init(key, RIJNDAEL256_KEYSIZE);
  unsigned char buffer[CIPHERBUF];
  
  memset(decipher_text, 0, CIPHERBUF);

  if(!ctx)
    return false;

  /* decipher */
  if(!cfb_decrypt(ctx, buffer, cipher_text, CIPHERBUF)) {
    clear_ctx(ctx);
    return false;
  }
  
  clear_ctx(ctx);

  /* check session id */
  if(strncmp((char *)buffer, SID, strlen(SID)))
    return false;
  
  memcpy(decipher_text, buffer + strlen(SID), CIPHERBUF);

  return(decipher_text[0] == 0x00 ? false : true);

}
