/* Copyright (C) 2003  Martin J. Muench <mjm@codito.de> */

#include "config.h"
#include "curses.h"

WINDOW *input=NULL, *output=NULL;

/* Nice curses UI */
void 
start_curses(void) 
{
  int x_loop;

  initscr(); /* initialize screen */
  cbreak();
  nonl();
  keypad(stdscr, TRUE);
  for (x_loop = 0; x_loop < COLS; x_loop++)
    mvwaddch(stdscr, LINES - 3, x_loop, '_');
  mvprintw(LINES - 3, COLS - 26, "ICMP_Chat_(mjm_|_2003)");
  move(LINES - 2, 0);
  refresh();
  input = subwin(stdscr, 2, COLS, LINES - 2, 0);
  scrollok(input, 1);
  output = subwin(stdscr, LINES - 4, COLS, 0, 0);
  scrollok(output, 1);
  touchwin(stdscr);
  refresh();
  werase(input); /* clear screens */
  wmove(input, 0, 0);
  wrefresh(input);
  werase(output);
  wrefresh(output);
}

/* Remove Nice curses UI */
void 
end_curses(void) 
{
  endwin();
}
