/* Copyright (C) 2003  Martin J. Muench <mjm@codito.de> */

#ifdef DEBUG
#    include "debug.h"
#    include "curses.h"
#endif

void 
debug(const char *fmt, ...)
{
#ifdef DEBUG
  extern WINDOW *output;
  char buffer[4096];
  va_list ap;
  
  memset(buffer, 0, sizeof(buffer));
  va_start(ap, fmt);
   vsnprintf(buffer, sizeof(buffer)-1, fmt, ap);
  va_end(ap);

  if(output==NULL)
    fprintf(stderr, "!!! %s\n", buffer);
  else
    wprintw(output, "!!! %s\n", buffer);
#endif
}
