#ifndef RIJNDAEL_H
#define RIJNDAEL_H

/* internal shit */
#define MAXKC        256/32
#define MAXROUNDS        14
  
/* rijndael context structure */
struct RIJNDAEL_context {
  int   ROUNDS;                          /* key-length-dependent number of rounds */
  unsigned char  keySched[MAXROUNDS+1][4][4];	 /* key schedule		*/
  unsigned char  keySched2[MAXROUNDS+1][4][4]; /* key schedule		*/
};

#ifndef CURSES_H
typedef enum bool__ {false = 0, true=1} bool;
#endif

/* interface */
#define RIJNDAEL_BLOCKSIZE    16
#define RIJNDAEL128_KEYSIZE   16
#define RIJNDAEL192_KEYSIZE   24
#define RIJNDAEL256_KEYSIZE   32

struct cfb_aes_context {
  struct RIJNDAEL_context c;
  unsigned char           iv[RIJNDAEL_BLOCKSIZE];
  size_t                  unused;
};

struct cfb_aes_context* init(const unsigned char *key, 
			     size_t len);

void clear_ctx(struct cfb_aes_context *ctx);

bool cfb_encrypt(struct cfb_aes_context *ctx,
		 unsigned char *outbuf, 
		 const unsigned char *inbuf, 
		 size_t len );

bool cfb_decrypt(struct cfb_aes_context *ctx,
		 unsigned char *outbuf, 
		 const unsigned char *inbuf, 
		 size_t len);

#endif /* RIJNDAEL_HH */
