/* Copyright (C) 2003  Martin J. Muench <mjm@codito.de> */

#include "config.h"
#include "wrap.h"
#include "curses.h"
#include "cipherwrap.h"
#include "sendicmp.h"

/* encipher string, construct and send icmp packet */
int
encipher_send(int rawsock, 
	     const char *host, 
	     int icmptype, 
	     int icmpseq, 
	     const unsigned char *key,
	     const char *text, 
	     ...)
{
  char buffer[CIPHERBUF];
  unsigned char cipherbuf[CIPHERBUF];
  va_list ap;

  memset(buffer, 0, sizeof(buffer));
  va_start(ap, text);
  vsnprintf(buffer, sizeof(buffer)-1, text, ap);
  va_end(ap);

  /* encipher buffer */
  if(!encipher_string(key, cipherbuf, "%s", buffer))
    return 0;
  
  return(sendpacket(rawsock, cipherbuf, host, icmptype, icmpseq) ? 1 : 0);
}

/* resolve ip */
int 
resolv(char *out, const char *host, int maxlen)
{

  struct hostent *hostent=NULL;

  if((hostent = gethostbyname(host)) == NULL)
    return 0;

  memset(out, 0, maxlen);
  strncpy(out, 
	 inet_ntoa(*(struct in_addr*)hostent->h_addr_list[0]), 
	 maxlen - 1);


  return(out[0] == 0x00 ? 0 : 1);
}

/* setup rawsocket */
int 
rawsock_setup(void)
{
  int rawsock, af=0;

  if ((rawsock=socket(AF_INET,SOCK_RAW,IPPROTO_ICMP)) < 0)
    return -1;

  if (setsockopt(rawsock,IPPROTO_IP,IP_HDRINCL,&af,sizeof(af)) < 0)
  {
    close(rawsock);
    return -1;
  }
  return rawsock;
}

/* catch sigint */
void 
Sigint(void)
{
  end_curses();
  fprintf(stderr, "\n>>> Received SIGINT, exiting...\n");
  exit(EXIT_FAILURE);
}
