/* Copyright (C) 2003  Martin J. Muench <mjm@codito.de> */

#include "config.h"
#include "sendicmp.h"

int 
sendpacket(int rawsock, 
	   const unsigned char *text, 
	   const char *host, 
	   int icmpcode, 
	   int icmpseq) 
{
  int pktsize, retval;
  unsigned char *packet=NULL, *data=NULL;
  struct icmp *icmp=NULL;
  
  pktsize = sizeof(struct icmp) + CIPHERBUF;
  
  if((packet = (unsigned char *)malloc(pktsize)) == NULL) 
    return 0;

  icmp = (struct icmp *)packet;
  data = (unsigned char *)(packet + sizeof(struct icmp));
  
  memset(packet, 0, pktsize);
  
  saddr.sin_family = AF_INET;
  saddr.sin_addr.s_addr = inet_addr(host);
  icmp->icmp_type = icmpcode;
  icmp->icmp_seq = icmpseq;

  memcpy(data, text, CIPHERBUF);
  
  icmp->icmp_cksum = in_cksum((u_short *)icmp,
  			      sizeof(struct icmp) + CIPHERBUF);

  retval = sendto(rawsock, packet, pktsize, 0, 
		  (struct sockaddr *)&saddr, sizeof(struct sockaddr));
  
  free(packet);
  
  return (retval < 0 ? 0 : 1);
}

/* Copied from FreeBSD ping.c  */
int 
in_cksum (u_short *addr, int len) 
{
  register int nleft = len;
  register u_short *w = addr;
  register int sum = 0;
  u_short answer = 0;
  while (nleft > 1) 
  {
    sum += *w++;
    nleft -= 2;
  }
  if (nleft == 1) 
  {
    *(u_char *)(&answer) = *(u_char *)w;
    sum += answer;
  }	
  sum = (sum >> 16) + (sum & 0xffff);
  sum += (sum >> 16);
  answer = ~sum;
  return (answer);
}
