/* Copyright (C) 2003  Martin J. Muench <mjm@codito.de> */

#include "config.h"
#include "setup.h"
#include "chat.h"
#include "curses.h"
#include "cipherwrap.h"
#include "sha256.h"
#include "wrap.h"

/* Functions */
static void Abort(const char *);
static void usage(void);

extern WINDOW *output, *input;

int 
main(int argc, char *argv[])
{
  char host[256], nick[16];
  unsigned char key[SHA256_HASH_SIZE];
  int icmptype=0, c, i=0, rawsock;

  while((c = getopt(argc, argv, "t:")) != -1)
  {
    switch(c)
    {
    case 't':
      icmptype=atoi(optarg);
      if(icmptype < 0 || icmptype >> ICMP_MAXTYPE)
	Abort("Invalid icmp_type");
      break;
    default:
      usage();
    }
  }

  argc -= optind;
  argv += optind;

  if(argc < 2)
    usage();

  if (geteuid() != 0)
    Abort("You need to be root.");

  /* Argv[0] = Hostname */
  if(!resolv(host, argv[0], sizeof(host)))
    Abort("Cannot lookup hostname");

#ifdef DEBUG
  debug("Host is: %s", host);
#endif

#ifdef DEBUG
  debug("icmp code is: %d", icmptype);
#endif
  
  /* Argv[1] = Nickname */
  memset(nick, 0, sizeof(nick));
  memcpy(nick, argv[1], sizeof(nick) - 1);

#ifdef DEBUG
  debug("Nickname is: %s", nick);
#endif

  /* Catch signals */
  signal(SIGINT, Sigint);
  
  if((rawsock=rawsock_setup()) < 0)
    Abort("Cannot setup rawsocket");

  /* Key */
  Getpass(key, sizeof(key));
  
  /* Start curses ui */
  start_curses();
  wprintw(output, "%s", BANNER);
  wrefresh(output);

  i=chat(rawsock, host, nick, icmptype, key);
 
  /* burn keybuffer */
  memset(key, 0, sizeof(key));

  /* Close raw socket */
  close(rawsock);

  if(!i)
    Abort("An error occured");
  else
    end_curses();

  exit(EXIT_SUCCESS);
}

static void 
usage(void) 
{
  printf("\nICMP-Chat %s  (mjm|2003)\n"       \
	 "------------------------\n\n"               \
	 "Usage: %s [OPTIONS] <host> <nick>\n"        \
	 "       <host> = Host to chat with\n"        \
	 "       <nick> = Your nickname\n"            \
	 "OPTIONS:\n"                                 \
	 "       -t <type>  = specify icmp type (default: ECHO_REPLY)\n\n"  \
	 "\n", VERSION, PROGNAME);
  exit(EXIT_FAILURE);
}

static void 
Abort(const char *error)
{
  fprintf(stderr, "\n>>> %s\n", error);
  exit(EXIT_FAILURE);
}
