/*-
 * Copyright (c) 1999,2000
 *	Konstantin Chuguev.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Konstantin Chuguev
 *	and its contributors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	iconv (Charset Conversion Library) v2.0
 */

#include <errno.h>	/* errno */
#include <stdlib.h>	/* free */
#include <string.h>	/* strcmp */

#define ICONV_INTERNAL
#include <iconv.h>

iconv_t
iconv_open(const char *to, const char *from)
{
	iconv_converter *ic;

	if(!to || !from || iconv_get_aliases((char **)&from, (char **)&to))
		return (iconv_t)(-1);
	ic = strcmp(from, to) ? iconv_unicode_conv_init(to, from)
	                      : iconv_null_conv_init(to, from);
	free((void *)to);
	free((void *)from);
	return ic ? (iconv_t)(ic) : (iconv_t)(-1);
}

size_t
iconv(iconv_t cd, const char **inbuf, size_t *inbytesleft,
	char **outbuf, size_t *outbytesleft)
{
	if ((void *)cd == NULL) {
		errno = EBADF;
		return (size_t)(-1);
	}
	if (outbytesleft == NULL || *outbytesleft == 0 ||
	    outbuf == NULL || *outbuf == 0) {
		errno = E2BIG;
		return (size_t)(-1);
	}
	return ((iconv_converter *)cd)->convert((iconv_converter *)cd + 1,
	                                        (const unsigned char**)inbuf,
	                                        inbytesleft,
	                                        (unsigned char**)outbuf,
	                                        outbytesleft);
}

int
iconv_close(iconv_t cd)
{
	int res;

	if ((void *)cd == NULL) {
		errno = EBADF;
		return -1;
	}
	res = ((iconv_converter *)cd)->close((iconv_converter *)cd + 1);
	free((void *)cd);
	return res ? -1 : 0;
}
