
/*
 * * * * * * * * * * * * * * * * * * * * * *
 *                                         *
 * ICPLD Connection Uptime Checker         *
 * By: Erik Ljungstrm                     *
 * Mail: erik@ibiblio.org                  *
 * Alt mail: erik@storuman.nu              *
 * WWW: http://northernmost.org/~erik      *
 * Copying: See COPYING file (BSD license) *
 *                                         *
 * * * * * * * * * * * * * * * * * * * * * *
 * -----------------------------------------------------------------------
 * The human animal differs from the lesser primates in his passion for
 * lists of "Ten Best".
 *		-- H. Allen Smith
 * ------------------------------------------------------------------------
 *
 *  This is where the action is, start reading here.
 */

#include "cuc.h"

#include <iomanip>
#include <pwd.h>
#include <syslog.h>
#include <signal.h>
#include <sys/utsname.h>
#include <cstdio>
#include <assert.h>

int
main (int argc, char *argv[])
{

  errno = 0;
  string homedir;

  if (getenv ("HOME") != NULL)
    homedir = getenv ("HOME");
  else
    {
      struct passwd *getHome = getpwuid (getuid ());
      homedir = getHome->pw_dir;
    }
  assert(homedir.size()>0);

  string dir = homedir, logFile, totFile, pidFile, statFile, ip;
  string confFile = "/usr/local/etc", confFile2 = "/etc";
  string logFile6, htmlFile6, totFile6, ip6, fbip6;
  string htmlFile, statFile6;
  string fbip, savepwd;
  string cmd4up, cmd4dn;
  string cmd6up, cmd6dn;

  dir += "/.icpld";
  logFile = homedir + "/.icpld/log";
  logFile6 = homedir+ "/.icpld/log";
  totFile = homedir + "/.icpld/tot";
  totFile6 = homedir + "/.icpld/tot6";
  pidFile = homedir + "/.icpld/icpld.pid";
  statFile = homedir + "/.icpld/stat";
  confFile += "/icpld.conf";
  confFile2 += "/icpld.conf";
  string pint = "1.0";		/* pinging interval (not to be mixed up with -interval) */
  double checkPint = 1.0;
  savepwd = getCwd();
  firstRun (dir, logFile, totFile, statFile, htmlFile, htmlFile6, totFile6);
  int interval = 10, dinterval = 6, silent = 1, type = 0;
  bool noDaemon = false, noSound = false, haveHTML = false, gaveLog =
    false, gaveTurn = false, gaveQuit = false, haveV4 = true, haveV6 = false;
  if (fileCheck (confFile) == "EX")
    {
      parseconf (logFile6, htmlFile6, fbip6, ip6, dir, homedir, logFile, totFile,
		 htmlFile, confFile, ip, fbip, pint, dinterval, interval,
		 noDaemon, noSound, cmd4up, cmd4dn, cmd6dn, cmd6up);
      htmlFile = fixPath (htmlFile, homedir, savepwd);
      logFile = fixPath (logFile, homedir, savepwd);
#ifdef HAVE_IPV6
      htmlFile6 = fixPath (htmlFile6, homedir, savepwd);
      logFile6 = fixPath (logFile6, homedir, savepwd);
#endif


    }				/* if (fileCheck(confFile)... */

  else if (fileCheck (confFile2) == "EX")
    {
      cout << "Could not find " << confFile << ". Falling back on " <<
	confFile2 << endl;
      parseconf (logFile6, htmlFile6, fbip6, ip6, dir, homedir, logFile, totFile,
		 htmlFile, confFile2, ip, fbip, pint, dinterval, interval,
		 noDaemon, noSound, cmd4up, cmd4dn, cmd6dn, cmd6up);
      htmlFile = fixPath (htmlFile, homedir, savepwd);
      logFile = fixPath (logFile, homedir, savepwd);
#ifdef HAVE_IPV6
      logFile6 = fixPath (logFile6, homedir, savepwd);
      htmlFile6 = fixPath (htmlFile6, homedir, savepwd);
#endif
    }


  else if (argc <= 1)
    {
      cout << "No " << confFile <<
	" file was found. And no command line arguments is available." <<
	endl;
      cout <<
	"Refer to 'man icpld' or 'icpld --help' for further information." <<
	endl;
      exit (EXIT_FAILURE);
    }


  /* Parsing command line arguments and set variables accordingly */
  parseArgs (argc, argv, logFile6, htmlFile6, fbip6, ip6, dir, homedir, logFile,
	     totFile, htmlFile, confFile, ip, fbip, pint, dinterval, interval,
	     noDaemon, noSound, silent, checkPint, gaveQuit, pidFile,
	     statFile, gaveTurn, type, savepwd, gaveLog, totFile6, cmd4up, cmd4dn, cmd6dn, cmd6up );


  /* Signal handlers */
  signal (SIGTERM, signal_handler);
  signal (SIGINT, signal_handler);
  signal (SIGQUIT, signal_handler);
  signal (SIGPIPE, signal_handler);

  /* We already have a process running, or some clumpsy illerate user has force killed it */
  if (fileCheck (pidFile) == "EX" && silent == 1) 

    {
      cout << "Refusing to start, since there appears to be another ICPLD process running.\n";
      cout << "Issue `icpld -quit` and try again" << endl;
      exit(EXIT_FAILURE);
    }
  else if (fileCheck (pidFile) == "EX" && silent == 0)
    exit (EXIT_FAILURE);

  /* Verify the input, IE check for non existant files, broken permissions etc. */
  checkInp (logFile6, htmlFile6, htmlFile, logFile, ip6, ip, haveV6, fbip,
	    fbip6, checkPint, haveHTML, pint, interval, dinterval, haveV4,
	    type);

  /* Tag the logs with necessary headers */
  wlogs (type, logFile, logFile6, ip6, haveV4, haveV6, htmlFile, htmlFile6,
	 ip, fbip, fbip6, haveHTML, statFile);

  /* Set the commands that we'll popen() accordingly */
  std::string command, command2;
#ifdef HAVE_IPV6
  std::string command6, command62;
#endif
#ifdef SOLARIS
  command = "ping " + ip + " 2";
  command2 = "ping " + fbip + " 2";
#ifdef HAVE_IPV6
  if (haveV6)
    {
      command6 = "ping -A inet6 " + ip6 + " 2";
      command62 = "ping -A inet6 " + fbip6 + " 2";
    }
#endif
#endif
#ifndef SOLARIS
  command = "ping -i " + pint + " -q -n -c 2 " + ip + " 1>/dev/null 2>&1";
  command2 = "ping -i " + pint + " -q -n -c 2 " + fbip + " 1>/dev/null 2>&1";
#ifdef HAVE_IPV6
  if (haveV6)
    {
      command6 =
	"ping6 -i " + pint + " -q -n -c 2 " + ip6 + " 1>/dev/null 2>&1";
      command62 =
	"ping6 -i " + pint + " -q -n -c 2 " + fbip6 + " 1>/dev/null 2>&1";
    }
#endif
#endif

  std::string totals;
  bool conDown = false, fbResp = false;
  int total = 0, seconds = 0, minutes = 0, hours = 0, loops = 0;
  int totSec = 0, totMin = 0, totHour = 0, rets, totDrop = 0;
  time_t timer, starttime = 0, endtime = 0;
  struct tm *tblock;
  timer = time (NULL);
  tblock = localtime (&timer);


  std::ofstream toStat (statFile.c_str (), std::ios::app);
  toStat << "UP" << endl << "Has not been down" << endl;
  /* Necessary to keep the formatting since asctime() which
     will be written to this file when a connection has come up
     generates a \n
  */
  toStat << "" << endl;
  if (type != 6)
    toStat << ip << endl;
  else /* IPv4 ip won't be shown if icpld is ran in IPv6-only mode */
    toStat << "" << endl;
  toStat << interval << endl;
  toStat << dinterval << endl;
  if (type != 6)
    toStat << logFile << endl << htmlFile << endl;
  else
    toStat << "" << endl << "" << endl;
  if (type !=4)
    toStat << ip6 << endl << logFile6 << endl << htmlFile6 << endl;
  else 
    toStat << "" << endl << "" << endl << "" << endl;
  

  

  toStat.close();
  char buf[BUFSIZ] = "";
  FILE *ptr, *ptr2;
#ifdef HAVE_IPV6
  FILE *ptr6, *ptr62;
  int totDrop6 = 0;
#endif
  std::ifstream readTot (totFile.c_str (), ios::binary);
  while (getline (readTot, totals))
    {
      loops++;
      if (loops == 1)
	total = atoi (totals.c_str ());
      else if (loops == 2)
	totSec = atoi (totals.c_str ());
      totals = "";
    }



  loops = 0;
  readTot.close ();
  if (!noDaemon)
    daemonize (1, 0, silent);
  else
    cout << "Staying in foreground.." << endl;
  if (fileCheck (pidFile) == "ENP")
    {
      openlog ("ICPLD", LOG_PID, LOG_USER);
      syslog (LOG_ERR, "Could not write pid file. Make sure you have permissions to write to ~/.icpld");
      closelog ();
      cerr << "Can not write pid-file. Terminating..." << endl;
      raise(SIGTERM);
    }

  std::ofstream writePid (pidFile.c_str (), ios::app);
  writePid << getpid () << endl;
  writePid.close ();
   


#ifdef HAVE_IPV6
  std::string totals6;
  bool conDown6 = false;
  bool fbResp6 = false;
  int total6 = 0, seconds6 = 0, minutes6 = 0, hours6 = 0, loops6 = 0;
  int totSec6 = 0, totMin6 = 0, totHour6 = 0, rets6;
  time_t timer6, starttime6 = 0, endtime6 = 0;
  struct tm *tblock6;
  timer6 = time (NULL);
  tblock6 = localtime (&timer6);
  char buf6[BUFSIZ] = "";

#endif
  



  do
    {
      if (haveV4 && type != 6)
	{
	  cout << flush;
	  strncpy (buf, "", 1);
	  cout << "Sending ICMP request to " << ip << "..." << endl;
	  ptr = popen (command.c_str (), "r");
	  if (ptr == NULL)
	    {
	      perror ("popen()");
	      cout << "Cleaning up and aborting..." << endl;
	      openlog ("ICPLD", LOG_PID, LOG_USER);
	      syslog (LOG_ERR,
		      "popen() failed. Could open pipe to shell. Terminating..");
	      closelog ();
	      raise(SIGTERM);
	      exit(EXIT_FAILURE);
	    }
	  /* Total Solaris wierdness! Unless the pointer is read from
	     this whole thing produces a 'Broken pipe'-error
	     Solaris is the only platform on which I've noticed this.
	     Are there any more?
	  */
#ifdef SOLARIS
	 char bufferSOL[80]; int sooooWierd=fread(bufferSOL,1,79,ptr);
	 sooooWierd=0;	 
#endif 
	  /* Get the actual return value from the command issued in popen() */
	  rets = pclose (ptr);
	  if (rets == -1){
	    perror ("pclose()");
	    cout << "Cleaning up and aborting..." << endl;
	    openlog ("ICPLD", LOG_PID, LOG_USER);
	    syslog (LOG_ERR,
		    "popen() failed. Could close the pipe to the shell. Terminating..");
	    closelog ();
	    raise(SIGTERM);
	    exit(EXIT_FAILURE);
	  } 
	  else if (rets == 32256 || rets == 127 || rets == 126)	/* Gutty guesses. */
	    {
	      cout <<
		"You do not seem to have the permissions to send ICMP requests on this system. Use\n";
	      cout << "a more privilegied user or alter permissions" << endl;
	      openlog ("ICPLD", LOG_PID, LOG_USER);
	      syslog (LOG_ERR,
		      "Could not execute 'ping'. Place the ping binary with proper permissions somewhere in your $PATH");
	      closelog ();
	      raise(SIGTERM);

	    }


	  if (rets != 0)	/* Ping returns 0 on success */
	    {
	      /* The ping failed, but if we have a fallback ip, try it */
	      if (fbip.size () > 0)
		{
		  cout << ip <<
		    " isn't responding. Trying fallback ip: " << fbip << endl;
		  ptr2 = popen (command2.c_str (), "r");
		  if (ptr2 == NULL)
		    {
		      perror ("popen()");
		      cout << "Cleaning up and aborting..." << endl;
		      openlog ("ICPLD", LOG_PID, LOG_USER);
		      syslog (LOG_ERR,
			      "popen() failed. Could open pipe to shell, reason unknown. Terminating..");
		      closelog ();
		      raise (SIGTERM);
		    }

		  if (pclose (ptr2) == 0)
		    {
		      if (!conDown)
			cout << "Got reply from " << fbip << endl;
		      else{
			system(cmd4up.c_str());
			cout << fbip << " replies. Connection back up!" << endl;
		      }
		      fbResp = true;
		      rets = 0;
		    }
		  else
		    {
		      cout << fbip << " is not responding. Connection broken."
			   << endl;
		      fbResp = false;
		    }
		}
	      else
		{
		  cout <<
		    "No fallback ip specified. Assuming connection is unavailable."
		       << endl;
		  fbResp = false;
		}
	      /* fbResp is set to false if the fallback ip fails to reply as well.
	         Write logs and start timer accordingly
	      */

	      if (!fbResp)
		{
		  std::ofstream toLog (logFile.c_str (), std::ios::app);

		  std::ifstream readTot (totFile.c_str (), ios::app);
		  while (getline (readTot, totals))
		    {
		      loops++;
		      if (loops == 1)
			total = atoi (totals.c_str ());
		      else if (loops == 2)
			totSec = atoi (totals.c_str ());
		      totals = "";
		    }
		  loops = 0;
		  readTot.close ();
		  if (!conDown)
		    {
		      system(cmd4dn.c_str());
		      timer = time (NULL);
		      tblock = localtime (&timer);
		      starttime = time (NULL);
		      toLog << "IPv4: Connection down: " << asctime (tblock);
		      if (haveHTML)
			{
			  std::ofstream toHTML (htmlFile.c_str (), std::ios::app);
			  toHTML << "IPv4: Connection down: " <<
			    asctime (tblock) << "<br>";
			  toHTML.close ();
			}
		      total += 1;
		      if (remove (statFile.c_str ()) == -1)
			{
			  cout << "Could not remove " << statFile << "..." <<
			    endl;
			  perror ("remove()");
			}
		      std::ofstream toStat (statFile.c_str (), std::ios::app);
		      toStat << "DOWN" << endl <<
			asctime (tblock) << endl << ip
			     << endl << interval << endl <<
			dinterval << endl << logFile
			     << endl << htmlFile << endl << ip6 << endl << logFile6
			     << endl << htmlFile6 << endl;
		      toStat.close ();
		    }
		  toLog.close ();

		  conDown = true;
		}
	    }

	  if (rets == 0)
	    {
	      if (conDown)
		{
		  if (!noSound && !noDaemon)
		    cout << "\a \a \a" << endl;
		  if (!fbResp){
		    cout << "Got ICMP reply from " << ip <<
		      ".. Connection available!" << endl;
		    system (cmd4up.c_str());
		  }
		  endtime = time (NULL);
		  seconds = endtime - starttime;
		  std::ifstream readTot (totFile.c_str (), ios::binary);
		  while (getline (readTot, totals))
		    {
		      loops++;
		      if (loops == 1)
			total = atoi (totals.c_str ());
		      else if (loops == 2)
			totSec = atoi (totals.c_str ());
		      totals = "";
		    }
		  loops = 0;
		  readTot.close ();
		  totSec += seconds;
		  if ((remove (totFile.c_str ()) == -1) && errno != ENOENT)
		    {
		      cout << "Could not overwrite " << totFile << "..." <<
			endl;
		      perror ("remove()");
		    }
		  std::ofstream toTot (totFile.c_str (), std::ios::app);
		  toTot << total << endl << totSec << endl;
		  toTot.close ();
		  if (seconds >= 60)
		    {
		      minutes = seconds / 60;
		      if (minutes >= 60)
			{
			  hours = minutes / 60;
			  minutes %= 60;
			}
		      seconds = seconds % 60;
		    }


		  if (totSec >= 60)
		    {
		      totMin = totSec / 60;
		      if (totMin >= 60)
			{
			  totHour = totMin / 60;
			  totMin %= 60;
			}
		      totSec = totSec % 60;
		    }


		  timer = time (NULL);
		  tblock = localtime (&timer);
		  std::ofstream toLog (logFile.c_str (), std::ios::app);

		  toLog << "IPv4: connection up: " <<
		    asctime (tblock) << "\tDown for: " <<
		    setw (2) << setfill ('0') << hours <<
		    ":" << setw (2) << setfill ('0') <<
		    minutes << ":" << setw (2) <<
		    setfill ('0') << seconds << endl;
		  toLog << "\t\tIPv4 Total: " << setw (2) <<
		    setfill ('0') << totHour << ":" <<
		    setw (2) << setfill ('0') << totMin <<
		    ":" << setw (2) << setfill ('0') << totSec << endl;
		  totDrop++;
		  toLog << "\tIPv4 connection dropped " << totDrop << " times." << endl;
		  toLog.close ();


		  std::ofstream toHTML (htmlFile.c_str (), std::ios::app);
		  toHTML << "IPv4: connection up: " <<
		    asctime (tblock) <<
		    "\tDown for: " << setw (2) <<
		    setfill ('0') << hours << ":"
			 << setw (2) << setfill ('0')
			 << minutes << ":" << setw (2)
			 << setfill ('0') << seconds << endl;
		  toHTML << "\t\tIPv4 Total: " << setw (2)
			 << setfill ('0') << totHour <<
		    ":" << setw (2) <<
		    setfill ('0') << totMin << ":"
			 << setw (2) << setfill ('0') << totSec << endl;

		  toHTML << "\tIPv4 connection dropped " << totDrop << " times." << endl;
		  toHTML.close ();
	
		  seconds = 0;
		  minutes = 0;
		  hours = 0;
		  totSec = 0;
		  totMin = 0;
		  totHour = 0;
		  if (remove (statFile.c_str ()) == -1)
		    {
		      cout << "Could not overwrite status file.. " << endl;
		      perror ("remove()");
		    }
		  std::ofstream toStat (statFile.c_str (), std::ios::app);
		  toStat << "UP" << endl << asctime (tblock) <<
		    endl << ip << endl << interval << endl
			 << dinterval << endl << logFile <<
		    endl << htmlFile << endl << ip6 << endl << logFile6 <<
		    endl << htmlFile6 << endl;
		  toStat.close ();
		  conDown = false;
		}
	    }
	}


#ifdef HAVE_IPV6



      if (haveV6 && type != 4)
	{


	  cout << flush;
	  strncpy (buf6, "", 1);
	  cout << "Sending ICMP request to " << ip6 << "..." << endl;
	  ptr6 = popen (command6.c_str (), "r");
	  if (ptr6 == NULL)
	    {
	      perror ("popen()");
	      cout << "Cleaning up and aborting..." << endl;
	      openlog ("ICPLD", LOG_PID, LOG_USER);
	      syslog (LOG_ERR,
		      "popen() failed. Could open pipe to shell, reason unknown. Terminating..");
	      closelog ();
	      raise(SIGTERM);
	    }
	  rets6 = pclose (ptr6);
	  if (rets6 == 32256 || rets6 == 127 || rets6 == 126)	/* Gutty guesses. */
	    {
	      cout <<
		"You do not seem to have the permissions to send ICMP requests on this system. Use\n";
	      cout << "a more privilegied user or alter permissions" << endl;
	      openlog ("ICPLD", LOG_PID, LOG_USER);
	      syslog (LOG_ERR,
		      "Could not execute 'ping6'. Place the ping6 binary with proper permissions somewhere in your $PATH");
	      closelog ();
	      raise(SIGTERM);

	    }


	  if (rets6 != 0)		/* ping6 also returns 0 on success */
	    {

	      if (fbip6.size () > 0)
		{
		  cout << ip6 << " isn't responding. Trying fallback ip: " << fbip6 << endl;
		  ptr62 = popen (command62.c_str (), "r");
		  if (ptr62 == NULL)
		    {
		      perror ("popen()");
		      cout << "Cleaning up and aborting..." << endl;
		      openlog ("ICPLD", LOG_PID, LOG_USER);
		      syslog (LOG_ERR, "popen() failed. Could open pipe to shell, reason unknown. Terminating..");
		      closelog ();
		      raise (SIGTERM);
		    }

		  if (pclose (ptr62) == 0) /* if ping6 returns 0 on fbip6 */
		    {
		      if (!conDown6)
			cout << "Got reply from " << fbip6 << endl;
		      else{
			system(cmd6up.c_str());
			cout << fbip6 << " replies. Connection back up!" << endl;
		      }
		      fbResp6 = true;
		      rets6 = 0;
		    }
		  else /* Anything other than 0 is considered failure */
		    {
		      cout << fbip6 << " is not responding. Connection broken." <<
			endl;
		      fbResp6 = false;
		    }
		}
	      else /* No fallback */
		{
		  cout <<
		    "No IPv6 fallback ip specified. Assuming connection is unavailable."
		       << endl;
		  fbResp6 = false;
		}

	      if (!fbResp6)
		{
		  std::ofstream toLog6 (logFile6.c_str (), ios::app);
		  std::ifstream readTot6 (totFile6.c_str (), ios::binary);
		  while (getline (readTot6, totals6))
		    { 
		      loops6++;
		      if (loops6 == 1)
			total6 = atoi (totals6.c_str ());
		      else if (loops6 == 2)
			totSec6 = atoi (totals6.c_str ());
		      totals6 = "";
		    }
		  loops6 = 0;
		  readTot6.close ();
		  if (!conDown6)
		    {
		      system(cmd6dn.c_str());
		      timer6 = time (NULL);
		      tblock6 = localtime (&timer6);
		      starttime6 = time (NULL);
		      toLog6 << "IPv6: Connection down: " << asctime (tblock6);
		      toLog6.close();
		      std::ofstream toHTML (htmlFile6.c_str (), ios::app);
		      toHTML << "IPv6: Connection down: " << asctime (tblock6);
		      toHTML.close ();
		      total6 += 1;
		      if (remove (statFile.c_str ()) == -1)
			{
			  cout << "Could not remove " << statFile << "..." << endl;
			  perror ("remove()");
			}
		      std::ofstream toStat (statFile.c_str (), std::ios::app);
		      toStat << "IPv6: DOWN" << endl <<
			asctime (tblock6) << endl << ip
			     << endl << interval << endl <<
			dinterval << endl << logFile
			     << endl << htmlFile << endl << ip6;
		      toStat.close ();
		    }

		  conDown6 = true;
		}
	    }

	  if (rets6 == 0)
	    {
	      if (conDown6)
		{
		  if (!noSound && !noDaemon)
		    cout << "\a \a \a" << endl;
		  if (!fbResp6){
		    system (cmd6up.c_str());
		    cout << "Got ICMP reply from " << ip6 <<
		      ".. Connection available!" << endl;
		  }
		  endtime6 = time (NULL);
		  seconds6 = endtime6 - starttime6;
		  std::ifstream readTot6 (totFile6.c_str (), ios::app);
		  while (getline (readTot6, totals6))
		    {
		      loops6++;
		      if (loops6 == 1)
			total6 = atoi (totals6.c_str ());
		      else if (loops6 == 2)
			totSec6 = atoi (totals6.c_str ());
		      totals6 = "";
		    }
		  loops6 = 0;
		  readTot6.close ();
		  totSec6 += seconds6;
		  if (remove (totFile6.c_str ()) == -1)
		    {
		      cout << "Could not overwrite " << totFile6 << "..." << endl;
		      perror ("remove()");
		    }
		  std::ofstream toTot6 (totFile6.c_str (), ios::app);
		  toTot6 << total6 << endl << totSec6 << endl;
		  toTot6.close ();
		  if (seconds6 >= 60)
		    {
		      minutes6 = seconds6 / 60;
		      if (minutes6 >= 60)
			{
			  hours6 = minutes6 / 60;
			  minutes6 %= 60;
			}
		      seconds6 = seconds6 % 60;
		    }


		  if (totSec6 >= 60)
		    {
		      totMin6 = totSec6 / 60;
		      if (totMin6 >= 60)
			{
			  totHour6 = totMin6 / 60;
			  totMin6 %= 60;
			}
		      totSec6 = totSec6 % 60;
		    }


		  timer6 = time (NULL);
		  tblock6 = localtime (&timer6);
		  std::ofstream toLog (logFile6.c_str (), std::ios::app);

		  toLog << "IPv6: connection up: " <<
		    asctime (tblock6) << "\tDown for: " <<
		    setw (2) << setfill ('0') << hours6 <<
		    ":" << setw (2) << setfill ('0') <<
		    minutes << ":" << setw (2) <<
		    setfill ('0') << seconds6 << endl;
		  toLog << "\t\tIPv6 Total: " << setw (2) <<
		    setfill ('0') << totHour6 << ":" <<
		    setw (2) << setfill ('0') << totMin6 <<
		    ":" << setw (2) << setfill ('0') << totSec6 << endl;
		  totDrop6++;
		  toLog << "\tIPv6 connection dropped: " << totDrop6 << " times." << endl;
		  toLog.close ();
		    
		  std::ofstream toHTML (htmlFile6.c_str (), ios::app);
		  toHTML << "IPv6: connection up: " << asctime (tblock6) <<
		    "\tDown for: " << setw (2) << setfill ('0') << hours6 <<
		    ":" << setw (2) << setfill ('0') << minutes6 << ":" <<
		    setw (2) << setfill ('0') << seconds6 << endl;
		  toHTML << "\t\tIPv6 Total: " << setw (2) << setfill ('0') <<
		    totHour6 << ":" << setw (2) << setfill ('0') << totMin6 <<
		    ":" << setw (2) << setfill ('0') << totSec6 << endl;
		  toHTML << "\tIPv6 connection dropped: " << totDrop6 << " times." << endl;
		  toHTML.close ();
		   
		  seconds6 = 0;
		  minutes6 = 0;
		  hours6 = 0;
		  totSec6 = 0;
		  totMin6 = 0;
		  totHour6 = 0;
		  if (remove (statFile.c_str ()) == -1)
		    {
		      cout << "Could not overwrite statFile.. " << endl;
		      perror ("remove()");
		    }
		  std::ofstream toStat (statFile.c_str (), std::ios::app);
		  toStat << "UP" << endl << asctime (tblock6) <<
		    endl << ip6 << endl << interval << endl
			 << dinterval << endl << logFile6 << endl << htmlFile6;
		  toStat.close ();
		  conDown6 = false;
		}
	    }
	}
#endif
#ifdef HAVE_IPV6
      if (conDown || conDown6)
	sleep (dinterval);
      else
	sleep (interval);
#endif
#ifndef HAVE_IPV6
      if (conDown)
	sleep (dinterval);
      else
	sleep (interval);
#endif
    }				/*do */
  while (1);
  return EXIT_SUCCESS;
}
