#include "cuc.h"
#include <assert.h>


#ifdef DARWIN
#include <sys/param.h>
#endif

string getCwd()
{
#ifndef DARWIN
  char *savepwd2;
  char *tempbuf;
  long tempsize = pathconf (".", _PC_PATH_MAX);
  tempbuf = new char[tempsize];
  assert(tempbuf != NULL);
  if ((savepwd2 = getcwd (tempbuf, (size_t) tempsize)) == NULL)
    {
      cout << "Could not obtain Current Working Directory..." << endl;
      perror ("getcwd()");
      exit (EXIT_FAILURE);
    }
  delete[] tempbuf;
  return savepwd2;
#endif

#ifdef DARWIN
  char buf[BUFSIZ];
  string savepwd2=getcwd(buf, MAXPATHLEN);
  return savepwd2;
#endif


}
