/* 
   This function kills a running icpld process
   by reading its pid from ~/.icpld/icpld.pid .
   
   icpld -quit goes here for instance
*/
#include "cuc.h"
#include <sys/types.h>
#include <signal.h>


bool
killProc (std::string fileName, int silent)
{
	string buf, pidNum;
	if (fileCheck (fileName) == "NE" || fileCheck(fileName) == "ENP")
	{
		if(silent == 1){
			cerr << "There doesn't seem to be an ICPLD process running." << endl;
			cerr << "Or perhaps the PID file is missing." << endl;
		}
		return false;
	}
	ifstream readPid (fileName.c_str (), ios::in);
	while (getline (readPid, buf))
		pidNum = buf;
	readPid.close();

	if(silent == 1)
		cout << "Sending process " << pidNum << " SIGTERM (signal 15)..." << endl;
	if (kill (atoi (pidNum.c_str ()), SIGTERM) != 0){
	  if (errno != ESRCH){ //No such process
	    perror("kill");
	    cout << "Removing possibly stale PID-file.." << endl;
	  }
	  remove (fileName.c_str());
	  return false;
	}
	if (silent == 1)
		cout << "Process terminated successfully..." << endl;
	return true;
}
