
/*
  This function is invoked by -reset on 
  the command line. It removes all files
  which icpld recognizes, and calls
  firstRun() to restore them
*/
  
#include "cuc.h"
#include <sys/stat.h>
#include <sstream>
bool reset(int silent, std::string dir, std::string apa, std::string pidFile, std::string logFile, std::string totFile, std::string statFile, std::string htmlFile, std::string htmlFile6, std::string totFile6)
{

  string oldLogFile = apa + "/.icpld/log.old", logFile6 = apa + "/.icpld/log6";
  cout << "Removing files.." << endl;
  if (fileCheck (pidFile) == "EX")
    killProc (pidFile, silent);
  if (logFile[0] == '~')
    {	//Expand ~ to home directory
      string tempLogFile = "";
      /* Remove the ~ char and move all the other chars one step back */
      for (unsigned int i = 1; i < logFile.size (); i++)
	tempLogFile += logFile[i];
      logFile = apa + tempLogFile;
    }

  if (remove (logFile.c_str ()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove logfile: " << strerror(errno) << endl;
      perror("remove()");
    }
  if (remove (logFile6.c_str()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove totals file: " << strerror(errno) << endl;
      perror("remove()");
    }
  if (remove (totFile.c_str ()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove totals file: " << strerror(errno) << endl;
      perror("remove()");
    }
  if (remove (statFile.c_str ()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove status file..." << strerror(errno) << endl;
      perror("remove()");
    }
  remove (oldLogFile.c_str ());

  if (remove (htmlFile.c_str ()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove html file:" << strerror(errno) << endl;
      perror("remove()");

    }

#ifdef HAVE_IPV6

  if (remove(htmlFile6.c_str()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove html file for IPv6: " << strerror(errno) << endl;
      perror("remove()");
    }
  if (remove(totFile6.c_str()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove totals file for IPv6: " << strerror(errno) << endl;
      perror("remove()");
    }
#endif
  string tempLog = logFile, num;
  struct stat s;
  stringstream conv;
  for (int i = 0; i < 1001 ; i++){ 
    conv << i;
    conv >> num;
    tempLog+=".";
    tempLog+=num;
    if (stat(tempLog.c_str(), &s) == 0) /* Remove if ~/.icpld/log.i exists */
      remove(tempLog.c_str());
    else 
      break; /* No more logs */
    conv.flush();
    conv.clear();
    tempLog=logFile;
  }
  if (remove (dir.c_str ()) == -1 && errno != ENOENT)
    {
      cout << "Could not remove icpld directory: " << strerror(errno) << endl;
      perror("remove()");
      cout << "Make sure no other files than the ones given either by config file, or\ncommand line resides in " << dir << endl;
    }		
  cout << "Creating new ones from template..." << endl;
  firstRun (dir, logFile, totFile, statFile, htmlFile, htmlFile6, totFile6);
  cout << "ICPLD is now in 'out of the box' state." <<
    endl;
  return true;
}
