/* 
   This function is called when -turn is given.
   It copies ~/.icpld/log to ~/.icpld/log.old.n, and 
   creates a new log.
*/

#include "cuc.h"
#include <sys/stat.h>
#include <sstream>
void
logTurn (std::string logFile)
{
  string newLog, tempLog = logFile, num;
  struct stat s;
  stringstream conv;
  /* It should be a fair assumption, that no one keeps
     more than 1000 old logs 
  */
  for (int i = 0; i < 1001 ; i++){ 
    conv << i;
    conv >> num;
    tempLog+=".";
    tempLog+=num;
    if (stat(tempLog.c_str(), &s) == -1){
      newLog = tempLog;
      break;
    }
    conv.flush();
    conv.clear();
    tempLog=logFile;

    /* Windows-style warning */
    if (i == 1000){
      cout << "You have reached the maximum amount of logs possible. I'm glad you are not my sys-admin." << endl;
      cout << "Investigate your ~/.icpld directory" << endl;
      exit(EXIT_FAILURE);
    }
  }

  if (rename (logFile.c_str(), newLog.c_str()) == -1){
    cout << "Could not rename " << logFile << " to " << newLog << endl;
    perror("rename()");
    exit(EXIT_FAILURE);
  }
  time_t timer;
  struct tm *tblock;
  timer = time (NULL);
  tblock = localtime (&timer);
  remove (logFile.c_str ());
  ofstream createLog (logFile.c_str (), ios::app);
  createLog << endl << "---------------------" << endl;
  createLog << "ICPLD logfile turned at: " << asctime (tblock);
  createLog << "---------------------" << endl << endl;
  createLog.close ();

}
