/*
   This file handles all the signals that
   may be sent to icpld during runtime.

   It catches INTERRUPT, SIGTERM and SIGQUIT
   and removes the pid file as well as terminate
   itself.
*/
#include "cuc.h"
#include <pwd.h>
#include <sys/signal.h>

void
signal_handler (int sig)
{
  if (sig == SIGINT) /* 2 */
    cout << "Caught INTERRUPT (signal " << sig << "), aborting..."  << endl;
  else if (sig == SIGTERM) /* 15 */
    cout << "Caught SIGTERM (signal " << sig << "), aborting..."  << endl;
  else if (sig == SIGQUIT) /* 3 */
    cout << "Caught SIGQUIT (signal " << sig << "), aborting..." << endl;
  else if (sig == SIGPIPE){ /* 13 This one is hopefully rare */
    cout << "Caught SIGPIPE (signal " << sig << "), aborting..." << endl;
    cout << "This signal is caught when a program tries to write to something";
    cout << "\nthat isn't there. Do you have a shell?" << endl;
  }
  string remFile;	
  char *getHome;
  if ((getHome = getenv ("HOME")) != NULL)
    remFile = getHome;
	
  else
    {
      struct passwd *getHome = getpwuid (getuid ());
      remFile = getHome->pw_dir;
      cout << "Could not read environment variable $HOME.. It's very recomended to set this." << endl;
      cout << "Reverted to passwd struct.." << endl;
    }
	
  remFile += "/.icpld/icpld.pid";

  if (remove (remFile.c_str ()) == -1)
    cout << "Could not remove " << remFile << ": " << strerror(errno) << endl;
  if (sig != SIGPIPE)
    exit (EXIT_SUCCESS);
  else
    exit (EXIT_FAILURE);
}
