/*
   This piece of code accepts an ip
   and which protocol family it belongs to
   and tries to resolve it in order to make
   sure the given IP is valid
*/
#include "cuc.h"

#include <netdb.h>
#include <sys/socket.h>

bool verip (std::string ip, int af)
{


#ifndef SOLARIS 
  if (af == 4){
    if (gethostbyname2(ip.c_str(), AF_INET) != NULL)
      return true;
    else {
      if(h_errno == HOST_NOT_FOUND)
	cout << "Could not find IPv4 host " << ip << endl;
      else
	cout << "An error occured while verifying " << ip << endl;
    }
  }
  
  else if(af == 6) { 
    if (gethostbyname2(ip.c_str(),AF_INET6) != NULL)
      return true;
    else
      cout << "This IPv6 address is wrongly formatted." << endl;
  }
#endif
#ifdef SOLARIS
  /* The lack of this variable caused the compilation error in 0.6.0 */
  int error_num;
  if (af==4) {
    if (getipnodebyname(ip.c_str(), AF_INET, 0, &error_num) != NULL)
      return true;
    else 
      cout << "This IPv4 address: " << ip << " is wrongly formatted." << endl;
  }
  else if (af == 6) {
    if (getipnodebyname(ip.c_str(), AF_INET6, 0, &error_num) != NULL)
      return true;
    else 
      cout << "This IPv6 address: " << ip << " is wrongly formatted." << endl;
  }
#endif
      
  return false;
}
