# $Id: RetrievalRecord.pm,v 1.3 2003/03/05 13:55:22 pop Exp $
# 
# Zebra perl API header
# =============================================================================
package IDZebra::RetrievalRecord;

use strict;
use warnings;

BEGIN {
    use IDZebra;
    our $VERSION = do { my @r = (q$Revision: 1.3 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r }; 
}

1;
# =============================================================================
# THIS IS Just the documentation, and some access methods... 
# The real code is autogenerated by SWIG in IDZebra.pm
# =============================================================================

sub errCode   { $_[0]->{errCode} }
sub errString { $_[0]->{errString} }
sub position  { $_[0]->{position} }
sub base      { $_[0]->{base} }
sub sysno     { $_[0]->{sysno} }
sub score     { $_[0]->{score} }
sub format    { $_[0]->{format} }
sub buf       { $_[0]->{buf} }

# =============================================================================

__END__

=head1 NAME

IDZebra::RetrievalRecord - Structure representing a retrieval record

=head1 SYNOPSIS

  foreach my $rec ($rs1->records()) {
      unless ($rec->errCode) {
         printf  ("Pos:%d, Base: %s, sysno: %d, score %d format: %s\n%s\n\n",
             $rec->position,
             $rec->base,
             $rec->sysno,
             $rec->score,
             $rec->format,
             $rec->buf
         );
      }
  }


=head1 DESCRIPTION

The object represents a Zebra retrieval record, as a "member" of a resultset. It's a read-only object. Beeing a tied reference, access to undefined members ("properties") may hurt.

=head1 PROPERTIES

The following properties are available trough both methods ($rec->errCode) and hash members ($rec->{errCode}):

=over 4

=item B<errCode>

The error code received when fetching this record. 0, if everything went OK.

=item B<errString>

Supplemental error information if applicable.

=item B<position>

Position of record in the resultset.

=item B<base>

The database the record belongs to

=item B<sysno>

System number (unique identifier provided by Zebra for each record) 

=item B<score>

The score of the resulting record

=item B<format>

Record format, (Z39.50)

=item B<buf>

The record data itself

=back

=head1 COPYRIGHT

Fill in

=head1 AUTHOR

Peter Popovics, pop@technomat.hu

=head1 SEE ALSO

Zebra documentation, IDZebra::Session, IDZebra::ResultSet manpages.

=cut

