/*
 * This file is part of IFM, the Interactive Fiction Mapper,
 * copyright (C) G. Hutchings 1997-2004.
 *
 * IFM comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under
 * certain conditions; see the file COPYING for details.
 */

/* A lexical scanner generated by flex */

/* Scanner skeleton version:
 * $Header: /usr/local/cvsroot/apps/ifm/src/ifm-scan.c,v 1.7 2004/10/15 11:50:27 glen Exp $
 */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <unistd.h>

/* Use prototypes in function declarations. */
#define YY_USE_PROTOS

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef __TURBOC__
 #pragma warn -rch
 #pragma warn -use
#include <io.h>
#include <stdlib.h>
#define YY_USE_CONST
#define YY_USE_PROTOS
#endif

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yy_start = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yy_start - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#define YY_BUF_SIZE 16384

typedef struct yy_buffer_state *YY_BUFFER_STATE;

extern int yyleng;
extern FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* The funky do-while in the following #define is used to turn the definition
 * int a single C statement (which needs a semi-colon terminator).  This
 * avoids problems with code like:
 *
 * 	if ( condition_holds )
 *		yyless( 5 );
 *	else
 *		do_something_else();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the yyless() call.
 */

/* Return all but the first 'n' matched characters back to the input stream. */

#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		*yy_cp = yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yy_c_buf_p = yy_cp = yy_bp + n - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext_ptr )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */
typedef unsigned int yy_size_t;


struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;
#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2
	};

static YY_BUFFER_STATE yy_current_buffer = 0;

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */


int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void yyrestart YY_PROTO(( FILE *input_file ));

void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));
void yy_flush_buffer YY_PROTO(( YY_BUFFER_STATE b ));
#define YY_FLUSH_BUFFER yy_flush_buffer( yy_current_buffer )

YY_BUFFER_STATE yy_scan_buffer YY_PROTO(( char *base, yy_size_t size ));
YY_BUFFER_STATE yy_scan_string YY_PROTO(( yyconst char *yy_str ));
YY_BUFFER_STATE yy_scan_bytes YY_PROTO(( yyconst char *bytes, int len ));

static void *yy_flex_alloc YY_PROTO(( yy_size_t ));
static void *yy_flex_realloc YY_PROTO(( void *, yy_size_t ));
static void yy_flex_free YY_PROTO(( void * ));

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! yy_current_buffer ) \
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE ); \
	yy_current_buffer->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (yy_current_buffer->yy_at_bol)

typedef unsigned char YY_CHAR;
FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;
typedef int yy_state_type;
extern char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yy_fatal_error YY_PROTO(( yyconst char msg[] ));

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define YY_NUM_RULES 87
#define YY_END_OF_BUFFER 88
static yyconst short int yy_accept[255] =
    {   0,
        0,    0,   88,   86,    3,    4,    5,    2,   86,   86,
       85,   82,   82,   82,   82,   11,   16,   82,   82,   82,
       82,   82,   82,   82,   82,   43,   82,   82,   59,   82,
       74,   78,    2,    3,    2,   83,   84,    0,   85,    0,
       82,   82,   82,   82,   82,   82,   82,   13,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   27,   82,   82,
       31,   32,   82,   82,   82,   82,   82,   82,   82,   44,
       82,   54,   82,   82,   82,   82,   82,   82,   62,   82,
       82,   68,   82,   82,   73,   82,   77,   82,   82,    2,
       83,   81,   82,    7,    8,   82,   10,   12,   82,   82,

       82,   82,   82,   82,   82,   82,   82,   24,   82,   82,
       82,   82,   82,   82,   82,   82,   82,   82,   82,   82,
       42,   82,   82,   82,   82,   82,   82,   82,   82,   56,
       82,   82,   82,   82,   82,   82,   82,   69,   82,   82,
       82,   82,   82,   82,   82,    2,   81,   82,   82,   14,
       15,   17,   82,   82,   20,   82,   82,   23,   25,   28,
       82,   82,   33,   34,   35,   36,   82,   82,   39,   40,
       41,   45,   82,   82,   49,   82,   82,   53,   82,   82,
       58,   60,   82,   82,   82,   82,   70,   82,   82,   82,
       82,   79,   80,    2,    6,   82,   82,   82,   82,   82,

       26,   82,   82,   37,   82,   82,   82,   82,   50,   82,
       82,   61,   63,   66,   67,   71,   72,   75,   76,    1,
        9,   82,   19,   21,   22,   29,   30,   38,   46,   47,
       48,   82,   82,   55,   82,   82,   82,    1,   82,   82,
       82,   57,   82,   82,   18,   82,   82,   82,   82,   51,
       52,   64,   65,    0
    } ;

static yyconst int yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    5,    6,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    7,    1,    8,    8,    8,
        8,    8,    8,    8,    8,    8,    8,    1,    1,    1,
        1,    1,    1,    1,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        9,    9,    9,    9,    9,    9,    9,    9,    9,    9,
        1,    1,    1,    1,    9,    1,   10,   11,   12,   13,

       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   25,   26,   27,   28,   29,   30,   31,   32,   33,
       34,    9,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst int yy_meta[35] =
    {   0,
        1,    1,    2,    1,    1,    1,    3,    4,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5
    } ;

static yyconst short int yy_base[262] =
    {   0,
        0,  491,  495,  497,  492,  497,  497,    0,    0,  485,
       28,  485,   30,   32,   33,   34,   37,   41,   49,   31,
       55,   50,   36,   62,   72,   74,   70,   78,  100,   87,
       76,  101,  470,  488,    0,    0,  481,  480,   82,    0,
      480,   35,   88,   84,   89,  109,   96,  106,  110,   47,
      113,  118,  114,  120,  121,  124,  126,  132,  133,  128,
      479,  135,  136,  141,   59,  137,  143,  145,  149,  151,
      168,  478,  155,  156,  152,  160,  157,  163,  477,  164,
      169,  476,  170,  161,  475,  175,  474,  173,  185,  462,
        0,    0,  192,  472,  471,  189,  470,  469,  193,  195,

      198,  200,  201,  202,  203,  204,  210,  468,  205,  211,
      216,  215,  219,  217,  223,  226,  227,  229,  230,  235,
      467,  231,  236,  239,  240,  246,  244,  245,  253,  466,
      254,  255,  258,  259,  260,  261,  262,  465,  267,  264,
      269,  268,  263,  272,  285,  448,    0,  273,  284,  463,
      462,  461,  286,  287,  460,  288,  289,  459,  291,  458,
      290,  292,  457,  456,  455,  454,  296,  298,  453,  452,
      451,  450,  299,  301,  449,  300,  311,  448,  310,  314,
      447,  446,  319,  318,  302,  323,  445,  315,  327,  329,
      331,  444,  443,  435,  441,  332,  333,  335,  338,  340,

      440,  342,  343,  439,  341,  344,  346,  353,  347,  349,
      355,  438,  361,  437,  436,  435,  434,  433,  432,    0,
      431,  352,  427,  415,  412,  408,  407,  403,  402,  401,
      400,  364,  370,  399,  371,  379,  373,    0,  374,  369,
      383,  398,  384,  385,  397,  387,  388,  389,  391,  396,
      395,  394,  393,  497,  420,  394,  423,  425,  358,  427,
      432
    } ;

static yyconst short int yy_def[262] =
    {   0,
      254,    1,  254,  254,  254,  254,  254,  255,  256,  254,
      254,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  255,  254,  255,  258,  254,  254,  254,  259,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  255,
      258,  260,  257,  257,  257,  257,  257,  257,  257,  257,

      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  255,  260,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  255,  257,  257,  257,  257,  257,  257,

      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  261,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  261,  257,  257,
      257,  257,  257,  257,  257,  257,  257,  257,  257,  257,
      257,  257,  257,    0,  254,  254,  254,  254,  254,  254,
      254
    } ;

static yyconst short int yy_nxt[532] =
    {   0,
        4,    5,    6,    7,    8,    9,   10,   11,   12,   13,
       14,   15,   16,   17,   18,   19,   20,   21,   22,   23,
       24,   25,   26,   27,   12,   12,   28,   29,   30,   31,
       12,   32,   12,   12,   38,   39,   40,   40,   40,   40,
       40,   40,   40,   40,   42,   45,   50,   40,   59,   64,
       43,   47,   44,   40,   46,   40,   40,   48,   53,   51,
       49,   40,   56,   93,   54,   40,   57,   55,   40,   52,
       60,   65,   58,   63,  101,   66,   40,   61,   40,   67,
       40,   69,   40,   62,   40,   68,  116,   70,   38,   39,
       40,   75,   73,   40,   40,   40,   83,   71,   86,   74,

       87,   76,   40,   96,   84,   72,   40,   40,   94,   77,
       85,   78,   40,   79,   88,   40,   40,   95,   89,   40,
       40,   97,   98,   80,   40,  102,   40,   40,   81,  103,
       40,   82,   40,  100,   40,  104,  105,   99,   40,   40,
      106,   40,   40,   40,  107,  111,  117,   40,  113,   40,
      112,   40,  108,  114,  115,   40,  109,   40,   40,  118,
      110,   40,   40,   40,  122,  119,   40,   40,  129,   40,
       40,  133,  120,  121,   40,   40,   40,  131,  136,   40,
      123,   40,  140,  132,  130,  138,  134,  142,  124,  141,
      125,   40,  126,  135,  127,   40,  128,  139,   40,   40,

      144,   40,  137,  143,   40,  148,   40,   40,   40,   40,
       40,   40,  149,  145,  154,  150,   40,   40,  159,  151,
      156,   40,   40,   40,  157,   40,  152,  153,  161,   40,
      155,  158,   40,   40,  160,   40,   40,   40,  162,  164,
      163,   40,   40,  172,  168,   40,   40,  165,  170,  169,
       40,   40,   40,  175,  166,  176,  174,  167,  178,   40,
       40,   40,  173,  171,   40,   40,   40,   40,   40,   40,
       40,  182,  177,   40,   40,   40,  181,  188,   40,   40,
      191,  190,  186,  180,  179,  183,  187,  185,  184,  189,
       40,   40,   40,   40,   40,   40,   40,   40,   40,  195,

      192,  193,   40,  202,   40,   40,   40,   40,   40,  204,
      196,  198,  200,  201,  197,  199,   40,   40,  203,  210,
       40,   40,  206,  207,   40,   40,  205,  209,  208,   40,
      214,  211,  212,   40,  213,   40,  215,   40,   40,   40,
      217,   40,  216,  218,   40,  221,   40,   40,   40,   40,
       40,  219,   40,   40,  224,   40,  227,  228,   40,   40,
      232,   40,   92,  223,  226,  230,  222,   40,  229,  231,
       40,  225,  239,  240,  236,   40,   40,   40,  233,   40,
       40,  235,  234,  241,  242,   40,  244,  245,  243,   40,
       40,   40,  237,   40,   40,   40,  246,   40,   36,   40,

       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
      247,  248,  249,   40,   40,  250,  251,  252,   40,  253,
       35,   40,   35,   35,   35,   41,   41,   41,   91,   91,
      147,  147,  238,   40,  238,  238,  238,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,  220,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
      194,   40,   40,   40,   40,   40,   40,   40,   40,  146,
       40,   40,   40,   40,   40,   40,   40,   37,   37,   34,
       90,   40,   37,   34,  254,   33,    3,  254,  254,  254,

      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254
    } ;

static yyconst short int yy_chk[532] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,   11,   11,   13,   20,   14,   15,
       16,   42,   23,   17,   13,   14,   17,   18,   20,   23,
       13,   16,   13,   50,   15,   19,   22,   16,   18,   17,
       16,   21,   19,   42,   18,   65,   19,   18,   24,   17,
       21,   24,   19,   22,   50,   24,   27,   21,   25,   24,
       26,   25,   31,   21,   28,   24,   65,   26,   39,   39,
       44,   28,   27,   30,   43,   45,   30,   26,   31,   27,

       31,   28,   47,   45,   30,   26,   29,   32,   43,   29,
       30,   29,   48,   29,   32,   46,   49,   44,   32,   51,
       53,   46,   47,   29,   52,   51,   54,   55,   29,   52,
       56,   29,   57,   49,   60,   52,   53,   48,   58,   59,
       54,   62,   63,   66,   55,   59,   66,   64,   62,   67,
       60,   68,   56,   63,   64,   69,   57,   70,   75,   66,
       58,   73,   74,   77,   70,   67,   76,   84,   73,   78,
       80,   77,   68,   69,   71,   81,   83,   75,   81,   88,
       71,   86,   84,   76,   74,   83,   78,   86,   71,   84,
       71,   89,   71,   80,   71,   96,   71,   83,   93,   99,

       88,  100,   81,   86,  101,   93,  102,  103,  104,  105,
      106,  109,   96,   89,  103,   99,  107,  110,  109,  100,
      105,  112,  111,  114,  106,  113,  101,  102,  111,  115,
      104,  107,  116,  117,  110,  118,  119,  122,  112,  114,
      113,  120,  123,  122,  118,  124,  125,  115,  120,  119,
      127,  128,  126,  125,  116,  126,  124,  117,  128,  129,
      131,  132,  123,  120,  133,  134,  135,  136,  137,  143,
      140,  133,  127,  139,  142,  141,  132,  140,  144,  148,
      143,  142,  137,  131,  129,  134,  139,  136,  135,  141,
      149,  145,  153,  154,  156,  157,  161,  159,  162,  148,

      144,  145,  167,  161,  168,  173,  176,  174,  185,  167,
      149,  154,  157,  159,  153,  156,  179,  177,  162,  179,
      180,  188,  173,  174,  184,  183,  168,  177,  176,  186,
      185,  180,  183,  189,  184,  190,  186,  191,  196,  197,
      189,  198,  188,  190,  199,  196,  200,  205,  202,  203,
      206,  191,  207,  209,  199,  210,  203,  205,  222,  208,
      209,  211,  259,  198,  202,  207,  197,  213,  206,  208,
      232,  200,  222,  232,  213,  240,  233,  235,  209,  237,
      239,  211,  210,  233,  235,  236,  237,  239,  236,  241,
      243,  244,  213,  246,  247,  248,  240,  249,  256,  253,

      252,  251,  250,  245,  242,  234,  231,  230,  229,  228,
      241,  243,  244,  227,  226,  246,  247,  248,  225,  249,
      255,  224,  255,  255,  255,  257,  257,  257,  258,  258,
      260,  260,  261,  223,  261,  261,  261,  221,  219,  218,
      217,  216,  215,  214,  212,  204,  201,  195,  194,  193,
      192,  187,  182,  181,  178,  175,  172,  171,  170,  169,
      166,  165,  164,  163,  160,  158,  155,  152,  151,  150,
      146,  138,  130,  121,  108,   98,   97,   95,   94,   90,
       87,   85,   82,   79,   72,   61,   41,   38,   37,   34,
       33,   12,   10,    5,    3,    2,  254,  254,  254,  254,

      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254,  254,  254,  254,  254,  254,  254,  254,  254,  254,
      254
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *yytext;
#line 1 "ifm-scan.l"
#define INITIAL 0
#line 2 "ifm-scan.l"
/* Lexical scanner */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <vars.h>

#include "ifm-main.h"
#include "ifm-util.h"
#include "ifm-parse.h"

#define yywrap() 1

/* Internal string buffer */
static vbuffer *sbuf = NULL;

/* Internal functions */
static void parse_prep_line(char *str);
#line 589 "ifm-scan.c"

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap YY_PROTO(( void ));
#else
extern int yywrap YY_PROTO(( void ));
#endif
#endif

#ifndef YY_NO_UNPUT
static void yyunput YY_PROTO(( int c, char *buf_ptr ));
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy YY_PROTO(( char *, yyconst char *, int ));
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen YY_PROTO(( yyconst char * ));
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif
#endif

#if YY_STACK_USED
static int yy_start_stack_ptr = 0;
static int yy_start_stack_depth = 0;
static int *yy_start_stack = 0;
#ifndef YY_NO_PUSH_STATE
static void yy_push_state YY_PROTO(( int new_state ));
#endif
#ifndef YY_NO_POP_STATE
static void yy_pop_state YY_PROTO(( void ));
#endif
#ifndef YY_NO_TOP_STATE
static int yy_top_state YY_PROTO(( void ));
#endif

#else
#define YY_NO_PUSH_STATE 1
#define YY_NO_POP_STATE 1
#define YY_NO_TOP_STATE 1
#endif

#ifdef YY_MALLOC_DECL
YY_MALLOC_DECL
#else
#if __STDC__
#ifndef __cplusplus
#include <stdlib.h>
#endif
#else
/* Just try to get by without declaring the routines.  This will fail
 * miserably on non-ANSI systems for which sizeof(size_t) != sizeof(int)
 * or sizeof(void*) != sizeof(int).
 */
#endif
#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */

#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( yy_current_buffer->yy_is_interactive ) \
		{ \
		int c = '*', n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else if ( ((result = fread( buf, 1, max_size, yyin )) == 0) \
		  && ferror( yyin ) ) \
		YY_FATAL_ERROR( "input in flex scanner failed" );
#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL int yylex YY_PROTO(( void ))
#endif

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	if ( yyleng > 0 ) \
		yy_current_buffer->yy_at_bol = \
				(yytext[yyleng - 1] == '\n'); \
	YY_USER_ACTION

YY_DECL
	{
	register yy_state_type yy_current_state;
	register char *yy_cp = NULL, *yy_bp = NULL;
	register int yy_act;

#line 35 "ifm-scan.l"


#line 746 "ifm-scan.c"

	if ( yy_init )
		{
		yy_init = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yy_start )
			yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! yy_current_buffer )
			yy_current_buffer =
				yy_create_buffer( yyin, YY_BUF_SIZE );

		yy_load_buffer_state();
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start;
		yy_current_state += YY_AT_BOL();
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				yy_last_accepting_state = yy_current_state;
				yy_last_accepting_cpos = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 255 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 497 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;


do_action:	/* This label is used only to access EOF actions. */


		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = yy_hold_char;
			yy_cp = yy_last_accepting_cpos;
			yy_current_state = yy_last_accepting_state;
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 37 "ifm-scan.l"
{
    /* Preprocessor line */
    parse_prep_line(yytext);
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 42 "ifm-scan.l"
/* Ignore other comments */
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 44 "ifm-scan.l"
/* Strip whitespace */
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 46 "ifm-scan.l"
{
    line_number++;
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 50 "ifm-scan.l"
{
    /* Quoted string */

    int c, quote = 0, eatspace = 0;

    /* Initialise buffer */
    if (sbuf == NULL)
        sbuf = vb_create();
    else
        vb_empty(sbuf);

    /* Slurp string in, one char at a time */
    while (1) {
        c = input();

        if        (c == EOF) {
            yyerror("unterminated string");
            break;
        } else if (c == '"' && !quote) {
            break;
        } else if (c == '\\' && !quote) {
            quote = 1;
            continue;
        } else if (c == '\n') {
            vb_putc(sbuf, ' ');
            eatspace = 1;
            line_number++;
        } else if (!eatspace || !isspace(c)) {
            vb_putc(sbuf, c);
        }

        if (!isspace(c))
            eatspace = 0;

        quote = 0;
    }

    yylval.sval = vb_getcopy(sbuf);
    return STRING;
}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 91 "ifm-scan.l"
{ return AFTER; }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 92 "ifm-scan.l"
{ return ALL; }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 93 "ifm-scan.l"
{ return ANY; }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 94 "ifm-scan.l"
{ return BEFORE; }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 95 "ifm-scan.l"
{ return CMD; }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 96 "ifm-scan.l"
{ return DOWN; }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 97 "ifm-scan.l"
{ return DIR; }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 98 "ifm-scan.l"
{ return DO; }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 99 "ifm-scan.l"
{ return DOWN; }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 100 "ifm-scan.l"
{ return DROP; }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 101 "ifm-scan.l"
{ return EAST; }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 102 "ifm-scan.l"
{ return EAST; }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 103 "ifm-scan.l"
{ return ENDSTYLE; }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 104 "ifm-scan.l"
{ return EXCEPT; }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 105 "ifm-scan.l"
{ return EXIT; }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 106 "ifm-scan.l"
{ return FINISH; }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 107 "ifm-scan.l"
{ return FOLLOW; }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 108 "ifm-scan.l"
{ return FROM; }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 109 "ifm-scan.l"
{ return GET; }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 110 "ifm-scan.l"
{ return GIVE; }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 111 "ifm-scan.l"
{ return GIVEN; }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 112 "ifm-scan.l"
{ return GO; }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 113 "ifm-scan.l"
{ return GOTO; }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 114 "ifm-scan.l"
{ return HIDDEN; }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 115 "ifm-scan.l"
{ return IGNORE; }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 116 "ifm-scan.l"
{ return IN; }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 117 "ifm-scan.l"
{ return IT; }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 118 "ifm-scan.l"
{ return ITEM; }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 119 "ifm-scan.l"
{ return JOIN; }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 120 "ifm-scan.l"
{ return KEEP; }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 121 "ifm-scan.l"
{ return LAST; }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 122 "ifm-scan.l"
{ return LEAVE; }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 123 "ifm-scan.l"
{ return LENGTH; }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 124 "ifm-scan.l"
{ return LINK; }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 125 "ifm-scan.l"
{ return LOSE; }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 126 "ifm-scan.l"
{ return LOST; }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 127 "ifm-scan.l"
{ return MAP; }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 128 "ifm-scan.l"
{ return NORTH; }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 129 "ifm-scan.l"
{ return NORTHEAST; }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 130 "ifm-scan.l"
{ return NEED; }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 131 "ifm-scan.l"
{ return NODROP; }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 132 "ifm-scan.l"
{ return NOLINK; }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 133 "ifm-scan.l"
{ return NOPATH; }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 134 "ifm-scan.l"
{ return NONE; }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 135 "ifm-scan.l"
{ return NORTH; }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 136 "ifm-scan.l"
{ return NORTHEAST; }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 137 "ifm-scan.l"
{ return NORTHWEST; }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 138 "ifm-scan.l"
{ return NOTE; }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 139 "ifm-scan.l"
{ return NORTHWEST; }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 140 "ifm-scan.l"
{ return ONEWAY; }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 141 "ifm-scan.l"
{ return OUT; }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 142 "ifm-scan.l"
{ return REQUIRE; }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 143 "ifm-scan.l"
{ return ROOM; }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 144 "ifm-scan.l"
{ return SOUTH; }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 145 "ifm-scan.l"
{ return SAFE; }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 146 "ifm-scan.l"
{ return SCORE; }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 147 "ifm-scan.l"
{ return SOUTHEAST; }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 148 "ifm-scan.l"
{ return SOUTH; }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 149 "ifm-scan.l"
{ return SOUTHEAST; }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 150 "ifm-scan.l"
{ return SOUTHWEST; }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 151 "ifm-scan.l"
{ return START; }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 152 "ifm-scan.l"
{ return STYLE; }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 153 "ifm-scan.l"
{ return SOUTHWEST; }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 154 "ifm-scan.l"
{ return TAG; }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 155 "ifm-scan.l"
{ return TASK; }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 156 "ifm-scan.l"
{ return TIMES; }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 157 "ifm-scan.l"
{ return TITLE; }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 158 "ifm-scan.l"
{ return TO; }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 159 "ifm-scan.l"
{ return UP; }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 160 "ifm-scan.l"
{ return UNDEF; }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 161 "ifm-scan.l"
{ return UNTIL; }
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 162 "ifm-scan.l"
{ return UP; }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 163 "ifm-scan.l"
{ return WEST; }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 164 "ifm-scan.l"
{ return WEST; }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 165 "ifm-scan.l"
{ return WITH; }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 167 "ifm-scan.l"
{
    yylval.sval = v_strdup(yytext);
    return ID;
}
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 172 "ifm-scan.l"
{
    yylval.sval = v_strdup(yytext);
    return ID;
}
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 177 "ifm-scan.l"
{
    yylval.sval = v_strdup(&yytext[1]);
    return VAR;
}
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 182 "ifm-scan.l"
{
    yylval.dval = atof(yytext);
    return REAL;
}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 187 "ifm-scan.l"
{
    yylval.ival = atoi(yytext);
    return INTEGER;
}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 192 "ifm-scan.l"
{ return yytext[0]; }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 194 "ifm-scan.l"
ECHO;
	YY_BREAK
#line 1324 "ifm-scan.c"
case YY_STATE_EOF(INITIAL):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between yy_current_buffer and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yy_n_chars = yy_current_buffer->yy_n_chars;
			yy_current_buffer->yy_input_file = yyin;
			yy_current_buffer->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yy_c_buf_p = yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yy_did_buffer_switch_on_eof = 0;

				if ( yywrap() )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yy_c_buf_p = yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yy_c_buf_p =
					yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yy_c_buf_p =
				&yy_current_buffer->yy_ch_buf[yy_n_chars];

				yy_current_state = yy_get_previous_state();

				yy_cp = yy_c_buf_p;
				yy_bp = yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of yylex */


/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()
	{
	register char *dest = yy_current_buffer->yy_ch_buf;
	register char *source = yytext_ptr;
	register int number_to_move, i;
	int ret_val;

	if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( yy_current_buffer->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yy_c_buf_p - yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yy_c_buf_p - yytext_ptr) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( yy_current_buffer->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		yy_current_buffer->yy_n_chars = yy_n_chars = 0;

	else
		{
		int num_to_read =
			yy_current_buffer->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */
#ifdef YY_USES_REJECT
			YY_FATAL_ERROR(
"input buffer overflow, can't enlarge buffer because scanner uses REJECT" );
#else

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = yy_current_buffer;

			int yy_c_buf_p_offset =
				(int) (yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yy_flex_realloc( (void *) b->yy_ch_buf,
							 b->yy_buf_size + 2 );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = yy_current_buffer->yy_buf_size -
						number_to_move - 1;
#endif
			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
			yy_n_chars, num_to_read );

		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	if ( yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			yy_current_buffer->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	yy_n_chars += number_to_move;
	yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yytext_ptr = &yy_current_buffer->yy_ch_buf[0];

	return ret_val;
	}


/* yy_get_previous_state - get the state just before the EOB char was reached */

static yy_state_type yy_get_previous_state()
	{
	register yy_state_type yy_current_state;
	register char *yy_cp;

	yy_current_state = yy_start;
	yy_current_state += YY_AT_BOL();

	for ( yy_cp = yytext_ptr + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			yy_last_accepting_state = yy_current_state;
			yy_last_accepting_cpos = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 255 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
	}


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
yy_state_type yy_current_state;
#endif
	{
	register int yy_is_jam;
	register char *yy_cp = yy_c_buf_p;

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 255 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 254);

	return yy_is_jam ? 0 : yy_current_state;
	}


#ifndef YY_NO_UNPUT
#ifdef YY_USE_PROTOS
static void yyunput( int c, register char *yy_bp )
#else
static void yyunput( c, yy_bp )
int c;
register char *yy_bp;
#endif
	{
	register char *yy_cp = yy_c_buf_p;

	/* undo effects of setting up yytext */
	*yy_cp = yy_hold_char;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = yy_n_chars + 2;
		register char *dest = &yy_current_buffer->yy_ch_buf[
					yy_current_buffer->yy_buf_size + 2];
		register char *source =
				&yy_current_buffer->yy_ch_buf[number_to_move];

		while ( source > yy_current_buffer->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		yy_current_buffer->yy_n_chars =
			yy_n_chars = yy_current_buffer->yy_buf_size;

		if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;


	yytext_ptr = yy_bp;
	yy_hold_char = *yy_cp;
	yy_c_buf_p = yy_cp;
	}
#endif	/* ifndef YY_NO_UNPUT */


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif
	{
	int c;

	*yy_c_buf_p = yy_hold_char;

	if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
			/* This was really a NUL. */
			*yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = yy_c_buf_p - yytext_ptr;
			++yy_c_buf_p;

			switch ( yy_get_next_buffer() )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin );

					/* fall through */

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap() )
						return EOF;

					if ( ! yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yy_c_buf_p = yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yy_c_buf_p;	/* cast for 8-bit char's */
	*yy_c_buf_p = '\0';	/* preserve yytext */
	yy_hold_char = *++yy_c_buf_p;

	yy_current_buffer->yy_at_bol = (c == '\n');

	return c;
	}


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif
	{
	if ( ! yy_current_buffer )
		yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_init_buffer( yy_current_buffer, input_file );
	yy_load_buffer_state();
	}


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif
	{
	if ( yy_current_buffer == new_buffer )
		return;

	if ( yy_current_buffer )
		{
		/* Flush out information for old buffer. */
		*yy_c_buf_p = yy_hold_char;
		yy_current_buffer->yy_buf_pos = yy_c_buf_p;
		yy_current_buffer->yy_n_chars = yy_n_chars;
		}

	yy_current_buffer = new_buffer;
	yy_load_buffer_state();

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yy_did_buffer_switch_on_eof = 1;
	}


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif
	{
	yy_n_chars = yy_current_buffer->yy_n_chars;
	yytext_ptr = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
	yyin = yy_current_buffer->yy_input_file;
	yy_hold_char = *yy_c_buf_p;
	}


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif
	{
	YY_BUFFER_STATE b;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yy_flex_alloc( b->yy_buf_size + 2 );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file );

	return b;
	}


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif
	{
	if ( ! b )
		return;

	if ( b == yy_current_buffer )
		yy_current_buffer = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yy_flex_free( (void *) b->yy_ch_buf );

	yy_flex_free( (void *) b );
	}


#ifndef YY_ALWAYS_INTERACTIVE
#ifndef YY_NEVER_INTERACTIVE
extern int isatty YY_PROTO(( int ));
#endif
#endif

#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif


	{
	yy_flush_buffer( b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

#if YY_ALWAYS_INTERACTIVE
	b->yy_is_interactive = 1;
#else
#if YY_NEVER_INTERACTIVE
	b->yy_is_interactive = 0;
#else
	b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
#endif
#endif
	}


#ifdef YY_USE_PROTOS
void yy_flush_buffer( YY_BUFFER_STATE b )
#else
void yy_flush_buffer( b )
YY_BUFFER_STATE b;
#endif

	{
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == yy_current_buffer )
		yy_load_buffer_state();
	}


#ifndef YY_NO_SCAN_BUFFER
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_buffer( char *base, yy_size_t size )
#else
YY_BUFFER_STATE yy_scan_buffer( base, size )
char *base;
yy_size_t size;
#endif
	{
	YY_BUFFER_STATE b;

	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) yy_flex_alloc( sizeof( struct yy_buffer_state ) );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b );

	return b;
	}
#endif


#ifndef YY_NO_SCAN_STRING
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_string( yyconst char *yy_str )
#else
YY_BUFFER_STATE yy_scan_string( yy_str )
yyconst char *yy_str;
#endif
	{
	int len;
	for ( len = 0; yy_str[len]; ++len )
		;

	return yy_scan_bytes( yy_str, len );
	}
#endif


#ifndef YY_NO_SCAN_BYTES
#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_scan_bytes( yyconst char *bytes, int len )
#else
YY_BUFFER_STATE yy_scan_bytes( bytes, len )
yyconst char *bytes;
int len;
#endif
	{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;

	/* Get memory for full buffer, including space for trailing EOB's. */
	n = len + 2;
	buf = (char *) yy_flex_alloc( n );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < len; ++i )
		buf[i] = bytes[i];

	buf[len] = buf[len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
	}
#endif


#ifndef YY_NO_PUSH_STATE
#ifdef YY_USE_PROTOS
static void yy_push_state( int new_state )
#else
static void yy_push_state( new_state )
int new_state;
#endif
	{
	if ( yy_start_stack_ptr >= yy_start_stack_depth )
		{
		yy_size_t new_size;

		yy_start_stack_depth += YY_START_STACK_INCR;
		new_size = yy_start_stack_depth * sizeof( int );

		if ( ! yy_start_stack )
			yy_start_stack = (int *) yy_flex_alloc( new_size );

		else
			yy_start_stack = (int *) yy_flex_realloc(
					(void *) yy_start_stack, new_size );

		if ( ! yy_start_stack )
			YY_FATAL_ERROR(
			"out of memory expanding start-condition stack" );
		}

	yy_start_stack[yy_start_stack_ptr++] = YY_START;

	BEGIN(new_state);
	}
#endif


#ifndef YY_NO_POP_STATE
static void yy_pop_state()
	{
	if ( --yy_start_stack_ptr < 0 )
		YY_FATAL_ERROR( "start-condition stack underflow" );

	BEGIN(yy_start_stack[yy_start_stack_ptr]);
	}
#endif


#ifndef YY_NO_TOP_STATE
static int yy_top_state()
	{
	return yy_start_stack[yy_start_stack_ptr - 1];
	}
#endif

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

#ifdef YY_USE_PROTOS
static void yy_fatal_error( yyconst char msg[] )
#else
static void yy_fatal_error( msg )
char msg[];
#endif
	{
	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
	}



/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
		yytext[yyleng] = yy_hold_char; \
		yy_c_buf_p = yytext + n; \
		yy_hold_char = *yy_c_buf_p; \
		*yy_c_buf_p = '\0'; \
		yyleng = n; \
		} \
	while ( 0 )


/* Internal utility routines. */

#ifndef yytext_ptr
#ifdef YY_USE_PROTOS
static void yy_flex_strncpy( char *s1, yyconst char *s2, int n )
#else
static void yy_flex_strncpy( s1, s2, n )
char *s1;
yyconst char *s2;
int n;
#endif
	{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
	}
#endif

#ifdef YY_NEED_STRLEN
#ifdef YY_USE_PROTOS
static int yy_flex_strlen( yyconst char *s )
#else
static int yy_flex_strlen( s )
yyconst char *s;
#endif
	{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
	}
#endif


#ifdef YY_USE_PROTOS
static void *yy_flex_alloc( yy_size_t size )
#else
static void *yy_flex_alloc( size )
yy_size_t size;
#endif
	{
	return (void *) malloc( size );
	}

#ifdef YY_USE_PROTOS
static void *yy_flex_realloc( void *ptr, yy_size_t size )
#else
static void *yy_flex_realloc( ptr, size )
void *ptr;
yy_size_t size;
#endif
	{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
	}

#ifdef YY_USE_PROTOS
static void yy_flex_free( void *ptr )
#else
static void yy_flex_free( ptr )
void *ptr;
#endif
	{
	free( ptr );
	}

#if YY_MAIN
int main()
	{
	yylex();
	return 0;
	}
#endif
#line 194 "ifm-scan.l"


/* Parse a preprocessor line */
static void
parse_prep_line(char *str)
{
    int flag, line;
    vlist *tokens;
    char *file;

    tokens = vl_split(str, " \t\"");
    if (vl_length(tokens) >= 2) {
        line = vl_iget(tokens, 1) - 1;
        file = vl_sgetref(tokens, 2);
        flag = vl_iget(tokens, 3);
        vl_destroy(tokens);
    } else {
        return;
    }

    switch_file(file, line, flag);
}
