;;; GNU Emacs Vars mode, for editing frozen data structures.
;;; Written by Glen Hutchings on Mon Jun 14 08:01:37 1999

;; This is mostly a copy of perl-mode.

(defvar vars-mode-map nil
  "Keymap used in Vars mode.")

(defvar vars-mode-hook '())

(if vars-mode-map
    nil
  (setq vars-mode-map (make-sparse-keymap)))

(defconst vars-function-regexp
  (regexp-opt '("SCALAR" "LIST" "HASH" "BUFFER" "FUNC" "REGEX" "QUEUE"
		"GRAPH" "VECTOR" "ARRAY" "MATRIX" "IMAGE") 'words)
  "Regexp matching function names in Vars mode.")

(defconst vars-keyword-regexp
  (regexp-opt '("NODE" "LINK" "TO" "ONEWAY" "NONE" "RGB" "RGBA" "GRAY"
		"SIZE") 'words)
  "Regexp matching keyword names in Vars mode.")

(defconst vars-builtin-regexp
  (regexp-opt '("REF" "UNDEF" "NULL") 'words)
  "Regexp matching builtin names in Vars mode.")

(defconst vars-font-lock-keywords
  (list
   (cons "#.*" font-lock-comment-face)
   (cons "\"[^\"]*\"" font-lock-string-face)
   (cons vars-function-regexp font-lock-function-name-face)
   (cons vars-keyword-regexp font-lock-keyword-face)
   (cons vars-builtin-regexp font-lock-builtin-face))
  "Font-lock keywords in Vars mode.")

(add-hook 'vars-mode-hook
	  (function (lambda ()
		      (make-local-variable 'font-lock-defaults)
		      (setq font-lock-defaults '(vars-font-lock-keywords t)))))

(defun vars-mode ()
  "Major mode for editing Vars frozen data structures.

Calling this function invokes the function(s) \"vars-mode-hook\"
before doing anything else."
  (interactive)
  ;; Copy perl mode.
  (perl-mode)
  ;; Become the current major mode.
  (setq major-mode 'vars-mode)
  (setq mode-name "Vars")
  ;; Activate keymap.
  (use-local-map vars-mode-map)
  (run-hooks 'vars-mode-hook))
