/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */

/*!
  @file
  @brief Destruction functions.
*/

#ifndef VARS_DESTROY_H
#define VARS_DESTROY_H

#ifdef __cplusplus
extern "C" {
#endif

extern void v_destroy(void *ptr);
extern void v_destroy_default(void (*func)(void *ptr));
extern void v_destroy_with(void *ptr, void (*func)(void *ptr));
extern void *v_gc(void *ptr);
extern void v_pop_gc(void);
extern void v_push_gc(void);

#ifdef __cplusplus
}
#endif

#endif
