/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */

/*!
  @file
  @brief Option parsing functions.
*/

#ifndef VARS_GETOPT_H
#define VARS_GETOPT_H

#include <vars-hash.h>

/*! Option parsing flags */
enum v_oflag {
    V_OPT_ARG,                  /*!< Requires an argument */
    V_OPT_OPTARG,               /*!< Takes an optional argument */
    V_OPT_FLAG,                 /*!< Takes no argument */
    V_OPT_LIST,                 /*!< Is a listable argument */
    V_OPT_RANGE                 /*!< Is a numeric range argument */
};

#ifdef __cplusplus
extern "C" {
#endif

extern void v_optgroup(char *desc);
extern void v_option(char optletter, char *optname, enum v_oflag type,
                     char *argname, char *fmt, ...);
extern vhash *vh_getopt(int argc, char *argv[]);
extern void v_usage(char *fmt, ...);
extern vlist *vl_parse_list(char *list);

#ifdef __cplusplus
}
#endif

#endif
