/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */

/*!
  @file
  @brief Matrix functions and macros.
  @ingroup matrix
*/

#ifndef VARS_MATRIX_H
#define VARS_MATRIX_H

#include <vars-type.h>

/*! @brief Abort if a pointer is not a matrix. */
#define VM_CHECK(ptr)      V_CHECK(ptr, vmatrix_type, "MATRIX")

/*! @brief Check if a pointer is a matrix type. */
#define v_ismatrix(ptr)    (ptr != NULL && vt_type(ptr) == vmatrix_type) 

/*! @brief Matrix type. */
typedef struct v_matrix vmatrix;

/*! @brief Matrix type variable. */
extern vtype *vmatrix_type;

#ifdef __cplusplus
extern "C" {
#endif

extern int vm_columns(vmatrix *m);
extern vmatrix *vm_copy(vmatrix *m);
extern vmatrix *vm_create(void);
extern vmatrix *vm_create_size(int nrows, int ncols);
extern vtype *vm_declare(void);
extern void vm_destroy(vmatrix *m);
extern vmatrix *vm_fread(FILE *fp);
extern int vm_freeze(vmatrix *m, FILE *fp);
extern int vm_fwrite(vmatrix *m, FILE *fp);
extern float vm_get(vmatrix *m, int row, int col);
extern void vm_print(vmatrix *m, FILE *fp);
extern void vm_require(vmatrix *m, int nrows, int ncols);
extern int vm_rows(vmatrix *m);
extern void vm_set_size(vmatrix *m, int nrows, int ncols);
extern void vm_store(vmatrix *m, int row, int col, float val);
extern vmatrix *vm_thaw(FILE *fp);
extern int vm_traverse(vmatrix *m, int (*func)());

#ifdef __cplusplus
}
#endif

#endif
