/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */


/*  A Bison parser, made from /home/glen/work/vars/src/vars-parser.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	VALUE	257
#define	ID	258
#define	EQ	259
#define	NE	260
#define	GE	261
#define	GT	262
#define	LE	263
#define	LT	264
#define	AND	265
#define	OR	266
#define	PLUS	267
#define	MINUS	268

#line 116 "vars-parser.y"

#define __NO_MATH_INLINES

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <errno.h>
#include <math.h>

#ifndef DOXYGEN_IGNORE
#include "vars-config.h"
#include "vars-buffer.h"
#include "vars-hash.h"
#include "vars-macros.h"
#include "vars-memory.h"
#include "vars-parser.h"
#include "vars-regex.h"
#endif

/* Internalize yacc variables */
#define	yymaxdepth                 yy_vars_maxdepth
#define	yyparse                    yy_vars_parse
#define	yylex                      yy_vars_lex
#define	yyerror                    yy_vars_error
#define	yylval                     yy_vars_lval
#define	yychar                     yy_vars_char
#define	yydebug                    yy_vars_debug
#define	yypact                     yy_vars_pact
#define	yyr1                       yy_vars_r1
#define	yyr2                       yy_vars_r2
#define	yydef                      yy_vars_def
#define	yychk                      yy_vars_chk
#define	yypgo                      yy_vars_pgo
#define	yyact                      yy_vars_act
#define	yyexca                     yy_vars_exca
#define yyerrflag                  yy_vars_errflag
#define yynerrs                    yy_vars_nerrs
#define	yyps                       yy_vars_ps
#define	yypv                       yy_vars_pv
#define	yys                        yy_vars_s
#define	yy_yys                     yy_vars_yys
#define	yystate                    yy_vars_state
#define	yytmp                      yy_vars_tmp
#define	yyv                        yy_vars_v
#define	yy_yyv                     yy_vars_yyv
#define	yyval                      yy_vars_val
#define	yylloc                     yy_vars_lloc
#define yyreds                     yy_vars_reds
#define yytoks                     yy_vars_toks
#define yylhs                      yy_vars_yylhs
#define yylen                      yy_vars_yylen
#define yydefred                   yy_vars_yydefred
#define yydgoto                    yy_vars_yydgoto
#define yysindex                   yy_vars_yysindex
#define yyrindex                   yy_vars_yyrindex
#define yygindex                   yy_vars_yygindex
#define yytable                    yy_vars_yytable
#define yycheck                    yy_vars_yycheck
#define yyname                     yy_vars_yyname
#define yyrule                     yy_vars_yyrule

/* Convenience macros */
#define COPY(s)                    vs_copy(s)
#define PUSH(s)                    vl_push(vp_stack, s) 
#define NV(s)                      vs_dget(s)
#define IV(s)                      vs_iget(s)
#define SV(s)                      vs_sget_buf(s, buf)
#define NSET(n)                    vs_dcreate(n)
#define SSET(n)                    vs_screate(n)

#define YYSTYPE                    vscalar *
#define YYPRINT(fp, type, value)   yyprint(fp, type, value)
#define YYERROR_VERBOSE            1

#define YYDEBUG 1

#define CALL_MATH_1(func) \
        vs_dcreate(func(vl_dget(args, 0)))

#define CALL_MATH_2(func) \
        vs_dcreate(func(vl_dget(args, 0), vl_dget(args, 1)))

/* Type definition */
struct v_parser {
    struct v_header id;         /* Type marker */
    struct v_hash *constants;   /* Constants */
    struct v_hash *variables;   /* Variables */
    struct v_hash *functions;   /* Functions */
    struct v_scalar *value;     /* Last parse value */
    struct v_list *errors;      /* List of parse errors */
    int undef_ok;               /* OK to refer to undefined variables? */
};

/* Function attributes */
struct v_pfunc {
    vscalar *(*func)(vlist *args);
    int minargs, maxargs;
};

/* Internal type abbreviations */
typedef struct v_pfunc vpfunc;

/* Type variable */
vtype *vparser_type = NULL;

/* Current parser for evaluation */
static vparser *vp_parser = NULL;

/* Current value stack */
static vlist *vp_stack = NULL;

/* Current function arg list */
static vlist *vp_arglist = NULL;

/* Current parse string */
static char *vp_input = NULL;

/* Current input line */
static int vp_line_number = 0;

/* Whether to report line numbers */
static int report_line = 0;

/* Internal arg list */
static vlist *args = NULL;

/* Scribble buffer */
static char buf[BUFSIZ];

/* Internal functions */
static void vp_add_builtins(vparser *p);
static vparser *vp_create_empty(void);
static int yylex(void);
static void yyprint(FILE *fp, int type, vscalar *s);
static void yyerror(char *msg);
static vscalar *builtin_acos(vlist *args);
static vscalar *builtin_asin(vlist *args);
static vscalar *builtin_atan(vlist *args);
static vscalar *builtin_atan2(vlist *args);
static vscalar *builtin_ceil(vlist *args);
static vscalar *builtin_cos(vlist *args);
static vscalar *builtin_exp(vlist *args);
static vscalar *builtin_fabs(vlist *args);
static vscalar *builtin_floor(vlist *args);
static vscalar *builtin_fmod(vlist *args);
static vscalar *builtin_hypot(vlist *args);
static vscalar *builtin_log(vlist *args);
static vscalar *builtin_log10(vlist *args);
static vscalar *builtin_max(vlist *args);
static vscalar *builtin_min(vlist *args);
static vscalar *builtin_pow(vlist *args);
static vscalar *builtin_sin(vlist *args);
static vscalar *builtin_sqrt(vlist *args);
static vscalar *builtin_tan(vlist *args);

/* List of builtin functions */
static struct builtin_func {
    char *name;
    vscalar *(*func)(vlist *args);
    int minargs, maxargs;
} builtin_functions[] = {
    "abs",   builtin_fabs,  1, 1,
    "acos",  builtin_acos,  1, 1,
    "asin",  builtin_asin,  1, 1,
    "atan",  builtin_atan,  1, 1,
    "atan2", builtin_atan2, 2, 2,
    "ceil",  builtin_ceil,  1, 1,
    "cos",   builtin_cos,   1, 1,
    "exp",   builtin_exp,   1, 1,
    "floor", builtin_floor, 1, 1,
    "hypot", builtin_hypot, 2, 2,
    "log",   builtin_log,   1, 1,
    "log10", builtin_log10, 1, 1,
    "min",   builtin_min,   2, VP_FUNC_NOLIMIT, 
    "max",   builtin_max,   2, VP_FUNC_NOLIMIT,
    "mod",   builtin_fmod,  2, 2,
    "pow",   builtin_pow,   2, 2,
    "sin",   builtin_sin,   1, 1,
    "sqrt",  builtin_sqrt,  1, 1,
    "tan",   builtin_tan,   1, 1,
    NULL,    NULL, 0
};

/* List of builtin constants */
static struct builtin_const {
    char *name;
    double value;
} builtin_constants[] = {
    "pi",    M_PI,              /* Pi */
    "e",     M_E,               /* E */
    "dtor",  M_PI / 180,        /* Degrees-to-radians */
    "rtod",  180 / M_PI,        /* Radians-to-degrees */
    NULL,    0.0
};

#ifndef YYSTYPE
#define YYSTYPE int
#endif
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		64
#define	YYFLAG		-32768
#define	YYNTBASE	30

#define YYTRANSLATE(x) ((unsigned)(x) <= 268 ? yytranslate[x] : 36)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    26,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,    24,     2,     2,     2,    21,     2,     2,    27,
    28,    19,    17,    29,    18,     2,    20,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    16,    13,     2,
    14,     2,    15,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,    25,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    22,    23
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     6,     9,    12,    14,    16,    19,    22,
    26,    30,    34,    38,    42,    46,    50,    54,    58,    62,
    66,    70,    74,    78,    82,    86,    89,    95,    99,   100,
   106,   107,   109,   113
};

static const short yyrhs[] = {    -1,
    30,    31,     0,    26,     0,    32,    26,     0,     1,    26,
     0,     3,     0,     4,     0,    17,    32,     0,    18,    32,
     0,    32,    17,    32,     0,    32,    18,    32,     0,    32,
    19,    32,     0,    32,    20,    32,     0,    32,    25,    32,
     0,    32,    21,    32,     0,    32,    13,    32,     0,    27,
    32,    28,     0,    32,     5,    32,     0,    32,     6,    32,
     0,    32,     8,    32,     0,    32,    10,    32,     0,    32,
     7,    32,     0,    32,     9,    32,     0,    32,    11,    32,
     0,    32,    12,    32,     0,    24,    32,     0,    32,    15,
    32,    16,    32,     0,     4,    14,    32,     0,     0,     4,
    27,    33,    34,    28,     0,     0,    35,     0,    34,    29,
    35,     0,    32,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   334,   335,   338,   339,   340,   346,   350,   362,   366,   370,
   374,   378,   382,   386,   393,   400,   404,   408,   412,   416,
   420,   424,   428,   432,   436,   440,   444,   448,   455,   462,
   472,   473,   474,   477
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","VALUE",
"ID","EQ","NE","GE","GT","LE","LT","AND","OR","';'","'='","'?'","':'","'+'",
"'-'","'*'","'/'","'%'","PLUS","MINUS","'!'","'^'","'\\n'","'('","')'","','",
"input","line","exp","@1","arglist","arg", NULL
};
#endif

static const short yyr1[] = {     0,
    30,    30,    31,    31,    31,    32,    32,    32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    32,    32,
    32,    32,    32,    32,    32,    32,    32,    32,    33,    32,
    34,    34,    34,    35
};

static const short yyr2[] = {     0,
     0,     2,     1,     2,     2,     1,     1,     2,     2,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     3,     3,     3,     3,     2,     5,     3,     0,     5,
     0,     1,     3,     1
};

static const short yydefact[] = {     1,
     0,     0,     6,     7,     0,     0,     0,     3,     0,     2,
     0,     5,     0,    29,     8,     9,    26,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,     0,     4,    28,    31,    17,    18,    19,
    22,    20,    23,    21,    24,    25,    16,     0,    10,    11,
    12,    13,    15,    14,    34,     0,    32,     0,    30,     0,
    27,    33,     0,     0
};

static const short yydefgoto[] = {     1,
    10,    55,    37,    56,    57
};

static const short yypact[] = {-32768,
    34,   -19,-32768,   -13,    38,    38,    38,-32768,    38,-32768,
    85,-32768,    38,-32768,   -12,   -12,   -12,    61,    38,    38,
    38,    38,    38,    38,    38,    38,    38,    38,    38,    38,
    38,    38,    38,    38,-32768,   149,    38,-32768,   210,   210,
    28,    28,    28,    28,   191,   170,   149,   107,   -10,   -10,
   -12,   -12,   -12,   -12,   128,   -26,-32768,    38,-32768,    38,
   149,-32768,    16,-32768
};

static const short yypgoto[] = {-32768,
-32768,    -1,-32768,-32768,   -43
};


#define	YYLAST		235


static const short yytable[] = {    11,
    13,    59,    60,    15,    16,    17,    12,    18,    31,    32,
    33,    36,    34,    14,    34,    64,    62,    39,    40,    41,
    42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
    52,    53,    54,    63,     2,     0,     3,     4,     0,     0,
     3,     4,     0,     0,    29,    30,    31,    32,    33,     0,
     5,     6,    34,     0,     5,     6,    61,     7,     0,     8,
     9,     7,     0,     0,     9,    19,    20,    21,    22,    23,
    24,    25,    26,    27,     0,    28,     0,    29,    30,    31,
    32,    33,     0,     0,     0,    34,     0,     0,    38,    19,
    20,    21,    22,    23,    24,    25,    26,    27,     0,    28,
     0,    29,    30,    31,    32,    33,     0,     0,     0,    34,
    35,    19,    20,    21,    22,    23,    24,    25,    26,    27,
     0,    28,    58,    29,    30,    31,    32,    33,     0,     0,
     0,    34,    19,    20,    21,    22,    23,    24,    25,    26,
    27,     0,    28,     0,    29,    30,    31,    32,    33,     0,
     0,     0,    34,    19,    20,    21,    22,    23,    24,    25,
    26,     0,     0,    28,     0,    29,    30,    31,    32,    33,
     0,     0,     0,    34,    19,    20,    21,    22,    23,    24,
    25,     0,     0,     0,     0,     0,    29,    30,    31,    32,
    33,     0,     0,     0,    34,    19,    20,    21,    22,    23,
    24,     0,     0,     0,     0,     0,     0,    29,    30,    31,
    32,    33,     0,     0,     0,    34,    21,    22,    23,    24,
     0,     0,     0,     0,     0,     0,    29,    30,    31,    32,
    33,     0,     0,     0,    34
};

static const short yycheck[] = {     1,
    14,    28,    29,     5,     6,     7,    26,     9,    19,    20,
    21,    13,    25,    27,    25,     0,    60,    19,    20,    21,
    22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
    32,    33,    34,     0,     1,    -1,     3,     4,    -1,    -1,
     3,     4,    -1,    -1,    17,    18,    19,    20,    21,    -1,
    17,    18,    25,    -1,    17,    18,    58,    24,    -1,    26,
    27,    24,    -1,    -1,    27,     5,     6,     7,     8,     9,
    10,    11,    12,    13,    -1,    15,    -1,    17,    18,    19,
    20,    21,    -1,    -1,    -1,    25,    -1,    -1,    28,     5,
     6,     7,     8,     9,    10,    11,    12,    13,    -1,    15,
    -1,    17,    18,    19,    20,    21,    -1,    -1,    -1,    25,
    26,     5,     6,     7,     8,     9,    10,    11,    12,    13,
    -1,    15,    16,    17,    18,    19,    20,    21,    -1,    -1,
    -1,    25,     5,     6,     7,     8,     9,    10,    11,    12,
    13,    -1,    15,    -1,    17,    18,    19,    20,    21,    -1,
    -1,    -1,    25,     5,     6,     7,     8,     9,    10,    11,
    12,    -1,    -1,    15,    -1,    17,    18,    19,    20,    21,
    -1,    -1,    -1,    25,     5,     6,     7,     8,     9,    10,
    11,    -1,    -1,    -1,    -1,    -1,    17,    18,    19,    20,
    21,    -1,    -1,    -1,    25,     5,     6,     7,     8,     9,
    10,    -1,    -1,    -1,    -1,    -1,    -1,    17,    18,    19,
    20,    21,    -1,    -1,    -1,    25,     7,     8,     9,    10,
    -1,    -1,    -1,    -1,    -1,    -1,    17,    18,    19,    20,
    21,    -1,    -1,    -1,    25
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 5:
#line 341 "vars-parser.y"
{
                    yyerrok;
                ;
    break;}
case 6:
#line 347 "vars-parser.y"
{
                    PUSH(yyvsp[0]);
                ;
    break;}
case 7:
#line 351 "vars-parser.y"
{
                    yyval = vp_get(vp_parser, SV(yyvsp[0]));

                    if (yyval != NULL)
                        yyval = COPY(yyval);
                    else
                        yyval = vs_create(V_UNDEF);

                    PUSH(yyvsp[0]);
                    PUSH(yyval);
                ;
    break;}
case 8:
#line 363 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 9:
#line 367 "vars-parser.y"
{
                    yyval = NSET(-NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 10:
#line 371 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) + NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 11:
#line 375 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) - NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 12:
#line 379 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) * NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 13:
#line 383 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) / NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 14:
#line 387 "vars-parser.y"
{
                    errno = 0;
                    yyval = NSET(pow(NV(yyvsp[-2]), NV(yyvsp[0]))); PUSH(yyval);
                    if (errno)
                        vp_errno("^", errno);
                ;
    break;}
case 15:
#line 394 "vars-parser.y"
{
                    errno = 0;
                    yyval = NSET(fmod(NV(yyvsp[-2]), NV(yyvsp[0]))); PUSH(yyval);
                    if (errno)
                        vp_errno("%", errno);
                ;
    break;}
case 16:
#line 401 "vars-parser.y"
{
                    yyval = COPY(yyvsp[0]); PUSH(yyval);
                ;
    break;}
case 17:
#line 405 "vars-parser.y"
{
                    yyval = COPY(yyvsp[-1]); PUSH(yyval);
                ;
    break;}
case 18:
#line 409 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) == NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 19:
#line 413 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) != NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 20:
#line 417 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) > NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 21:
#line 421 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) < NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 22:
#line 425 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) >= NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 23:
#line 429 "vars-parser.y"
{
                    yyval = NSET(NV(yyvsp[-2]) <= NV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 24:
#line 433 "vars-parser.y"
{
                    yyval = NSET(IV(yyvsp[-2]) && IV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 25:
#line 437 "vars-parser.y"
{
                    yyval = NSET(IV(yyvsp[-2]) || IV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 26:
#line 441 "vars-parser.y"
{
                    yyval = NSET(!IV(yyvsp[0])); PUSH(yyval);
                ;
    break;}
case 27:
#line 445 "vars-parser.y"
{
                    yyval = COPY(IV(yyvsp[-4]) ? yyvsp[-2] : yyvsp[0]); PUSH(yyval);
                ;
    break;}
case 28:
#line 449 "vars-parser.y"
{
                    yyval = COPY(yyvsp[0]);
                    PUSH(yyvsp[-2]);
                    PUSH(yyval);
                    vp_store(vp_parser, SV(yyvsp[-2]), COPY(yyvsp[0]));
                ;
    break;}
case 29:
#line 456 "vars-parser.y"
{
                    PUSH(yyvsp[-1]);
                    if (args != NULL)
                        vl_ppush(vp_arglist, args);
                    args = vl_create();
                ;
    break;}
case 30:
#line 463 "vars-parser.y"
{
                    if ((yyval = vp_call(vp_parser, SV(yyvsp[-4]), args)) == NULL)
                        yyval = vs_create(V_UNDEF);
                    PUSH(yyval);
                    vl_destroy(args);
                    args = vl_ppop(vp_arglist);
                ;
    break;}
case 34:
#line 478 "vars-parser.y"
{
                    vl_push(args, COPY(yyvsp[0]));
                ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 483 "vars-parser.y"


/* Add builtins to a parser */
static void
vp_add_builtins(vparser *p)
{
    int i;

    /* Install builtin constants */
    for (i = 0; builtin_constants[i].name != NULL; i++)
        vp_dconst(p,
                  builtin_constants[i].name,
                  builtin_constants[i].value);

    /* Install builtin functions */
    for (i = 0; builtin_functions[i].name != NULL; i++)
        vp_func(p,
                builtin_functions[i].name,
                builtin_functions[i].func,
                builtin_functions[i].minargs,
                builtin_functions[i].maxargs);
}

/*!
  @brief   Call a parser function.
  @ingroup parser_access
  @param   p Parser.
  @param   name Function name.
  @param   args List of arguments (or \c NULL, meaning no args).
  @return  Result.
  @retval  NULL if the call failed.
*/
vscalar *
vp_call(vparser *p, char *name, vlist *args)
{
    vscalar *result;
    int nargs = 0;
    vpfunc *f;

    VP_CHECK(p);
    if (args != NULL) {
        VL_CHECK(args);
        nargs = vl_length(args);
    }

    /* Get function info */
    if ((f = vh_pget(p->functions, name)) == NULL) {
        vp_err("function \"%s\" is undefined", name);
        return NULL;
    }

    /* Check no. of arguments */
    if (nargs < f->minargs || nargs > f->maxargs) {
        if (f->minargs == f->maxargs)
            vp_err("function \"%s\" requires %d argument%s",
                   name, f->minargs, (f->minargs == 1 ? "" : "s"));
        else if (f->maxargs == VP_FUNC_NOLIMIT)
            vp_err("function \"%s\" requires at least %d argument%s",
                   name, f->minargs, (f->minargs == 1 ? "" : "s"));
        else if (f->minargs == 0)
            vp_err("function \"%s\" requires at most %d argument%s",
                   name, f->maxargs, (f->maxargs == 1 ? "" : "s"));
        else
            vp_err("function \"%s\" requires between %d and %d arguments",
                   name, f->minargs, f->maxargs);

        return NULL;
    }

    /* Call function, checking for errors */
    errno = 0;
    result = (*f->func)(args);
    if (errno && vp_errno(name, errno)) {
        if (result != NULL)
            vs_destroy(result);
        return NULL;
    }

    return result;
}

/*!
  @brief   Declare a parser constant.
  @ingroup parser_custom
  @param   p Parser.
  @param   name Constant name.
  @param   val Its value.
*/
void
vp_const(vparser *p, char *name, vscalar *val)
{
    VP_CHECK(p);
    vh_istore(p->constants, name, 1);
    vh_store(p->variables, name, val);
}

/*!
  @brief   Return a copy of a parser.
  @ingroup parser_create
  @param   p Parser to copy.
  @return  Copy.

  Builtin functions and constants, and also current values of variables,
  are copied.
*/
vparser *
vp_copy(vparser *p)
{
    vpfunc *cf, *f;
    vparser *copy;
    vscalar *elt;
    char *name;

    VP_CHECK(p);

    copy = vp_create_empty();

    vh_destroy(copy->constants);
    copy->constants = vh_copy(p->constants);

    vh_destroy(copy->variables);
    copy->variables = vh_copy(p->variables);

    vh_foreach(name, elt, p->functions) {
        f = vs_pget(elt);
        cf = V_ALLOC(vpfunc, 1);
        cf->func = f->func;
        cf->minargs = f->minargs;
        cf->maxargs = f->maxargs;
        vh_pstore(copy->functions, name, cf);
    }

    if (V_DEBUG(V_DBG_INFO))
        v_info("Copied %s to 0x%p", v_vinfo(p), copy);

    return copy;
}

/*!
  @brief   Return a newly-created parser with builtins.
  @ingroup parser_create
  @return  New parser.
*/
vparser *
vp_create(void)
{
    vparser *p;

    p = vp_create_empty();
    vp_add_builtins(p);

    return p;
}

/* Return a newly-created empty parser */
static vparser *
vp_create_empty(void)
{
    static vheader *id = NULL;
    vparser *p;

    if (id == NULL) {
        vp_declare();
        id = vt_header(vparser_type);
    }

    p = V_ALLOC(vparser, 1);
    p->id = *id;

    p->constants = vh_create();
    p->variables = vh_create();
    p->functions = vh_create();

    p->value = NULL;
    p->errors = NULL;

    p->undef_ok = 1;

    if (V_DEBUG(V_DBG_INFO))
        v_info("Created %s", v_vinfo(p));

    return p;
}

/* Declare parser type */
vtype *
vp_declare(void)
{
    if (vparser_type == NULL) {
        vparser_type = vt_create("PARSER", "P");
        vt_copy_with(vparser_type, (void *(*)()) vp_copy);
        vt_read_with(vparser_type, (void *(*)()) vp_fread);
        vt_write_with(vparser_type, vp_fwrite);
        vt_print_with(vparser_type, vp_print);
        vt_destroy_with(vparser_type, vp_destroy);
    }

    return vparser_type;
}

/*!
  @brief   Delete a builtin constant.
  @ingroup parser_custom
  @param   p Parser.
  @param   name Constant to delete.

  Does nothing if the constant doesn't exist.
*/
void
vp_delconst(vparser *p, char *name)
{
    VP_CHECK(p);
    vh_delete(p->constants, name);
    vh_delete(p->variables, name);
}

/*!
  @brief   Delete a builtin function.
  @ingroup parser_custom
  @param   p Parser.
  @param   name Function to delete.

  Does nothing if the function doesn't exist.
*/
void
vp_delfunc(vparser *p, char *name)
{
    vpfunc *f;

    VP_CHECK(p);

    if ((f = vh_pget(p->functions, name)) != NULL) {
        vh_delete(p->functions, name);
        V_DEALLOC(f);
    }
}

/*!
  @brief   Deallocate a parser.
  @ingroup parser_create
  @param   p Parser.
*/
void
vp_destroy(vparser *p)
{
    vscalar *elt;
    char *name;
    vpfunc *f;

    VP_CHECK(p);

    if (V_DEBUG(V_DBG_INFO))
        v_info("Destroyed %s", v_vinfo(p));

    /* Destroy builtin functions */
    vh_foreach(name, elt, p->functions) {
        f = vs_pget(elt);
        V_DEALLOC(f);
    }

    /* Destroy parser */
    vh_destroy(p->constants);
    vh_destroy(p->variables);
    vh_destroy(p->functions);

    if (p->value != NULL)
        vs_destroy(p->value);
    if (p->errors != NULL)
        vl_destroy(p->errors);

    V_DEALLOC(p);
}

/*!
  @brief   Flag a parse error.
  @ingroup parser_custom
  @param   fmt Format string.

  This function is for use inside a user-defined parser function to
  indicate that an error has occurred.
*/
void
vp_err(char *fmt, ...)
{
    static vbuffer *err = NULL;
    char errbuf[BUFSIZ];

    if (err == NULL)
        err = vb_create();
    else
        vb_empty(err);

    if (vp_parser->errors == NULL)
        vp_parser->errors = vl_create();

    V_VPRINT(errbuf, fmt);

    if (report_line)
        vb_printf(err, "line %d: %s", vp_line_number, errbuf);
    else
        vb_puts(err, errbuf);

    vl_spush(vp_parser->errors, vb_get(err));
}

/* Flag an errno error */
int
vp_errno(char *name, int num)
{
    char namebuf[80];

    strcpy(namebuf, name);
    vp_err("function \"%s\": %s", namebuf, strerror(num));

    return 1;
}

/*!
  @brief   Return the last parser error.
  @ingroup parser_exp
  @param   p Parser.
  @return  Error string.
  @retval  NULL if no errors occurred.
*/
char *
vp_error(vparser *p)
{
    VP_CHECK(p);
    return (p->errors != NULL ? vl_shead(p->errors) : NULL);
}

/*!
  @brief   Set whether undefined variable references cause an error.
  @ingroup parser_custom
  @param   p Parser.
  @param   flag Yes or no.

  By default all undefined variables have the value zero.
*/
void
vp_error_undef(vparser *p, int flag)
{
    VP_CHECK(p);
    p->undef_ok = !flag;
}

/*!
  @brief   Return the list of parser errors.
  @ingroup parser_exp
  @param   p Parser.
  @return  List of error strings.
  @retval  NULL if no errors occurred.

  If an evaluation failed, then one or more errors occurred.  This
  function returns the list of errors encountered during the last
  evaluation.
*/
vlist *
vp_errors(vparser *p)
{
    VP_CHECK(p);
    return p->errors;
}

/*!
  @brief   Evaluate an expression.
  @ingroup parser_exp
  @param   p Parser.
  @param   expr Expression.
  @return  Whether successful.

  Use vp_value() to get the value of the expression.
*/
int
vp_eval(vparser *p, char *expr)
{
    VP_CHECK(p);

    /* Initialise */
    if (vp_stack == NULL) {
        vp_stack = vl_create();
        v_cleanup(vp_stack);
    } else {
        vl_empty(vp_stack);
    }

    if (vp_arglist == NULL) {
        vp_arglist = vl_create();
        v_cleanup(vp_arglist);
    }

    if (p->value != NULL)
        vs_destroy(p->value);

    if (p->errors != NULL)
        vl_destroy(p->errors);
    p->errors = NULL;

    vp_parser = p;
    vp_input = expr;
    vp_line_number = 1;
    report_line = (strchr(expr, '\n') != NULL);

    /* Let's parse! */
    yyparse();
    vp_parser = NULL;

    /* Tidy up */
    report_line = 0;

    /* Save return value */
    if (vl_length(vp_stack) > 0)
        p->value = vl_pop(vp_stack);
    else
        p->value = vs_create(V_UNDEF);

    return (p->errors == NULL);
}

/*!
  @brief   Return whether a variable exists.
  @ingroup parser_access
  @param   p Parser.
  @param   name Variable name.
  @return  Yes or no.
*/
int
vp_exists(vparser *p, char *name)
{
    VP_CHECK(p);
    return vh_exists(p->variables, name);
}

/* Read parser from a stream */
vparser *
vp_fread(FILE *fp)
{
    vparser *p;

    /* Initialise */
    p = vp_create_empty();
    vp_add_builtins(p);

    /* Read variables */
    vh_destroy(p->variables);
    if ((p->variables = vh_fread(fp)) == NULL)
        return NULL;

    /* Read constant flags */
    vh_destroy(p->constants);
    if ((p->constants = vh_fread(fp)) == NULL)
        return NULL;

    if (V_DEBUG(V_DBG_IO))
        v_info("Read %s", v_vinfo(p));

    return p;
}

/*!
  @brief   Declare a parser function.
  @ingroup parser_custom
  @param   p Parser.
  @param   name Function name.
  @param   func Function.
  @param   minargs Minimum no. of arguments.
  @param   maxargs Maximum no. of arguments.
  @see     vp_func_min(), vp_func_max(), vp_func_args(), vp_func_any()

  Declare a parser function with the given name, function and range of
  arguments.  Overrides any previous definition.

  A parser function is one that accepts a list of scalars as arguments and
  returns a single scalar, which should be of type V_INT, V_DOUBLE or
  V_STRING.  In vp_eval(), the number of arguments supplied to the function
  must be between \c minargs and \c maxargs or a parse error is given.  If
  \c maxargs is VP_FUNC_NOLIMIT, then there is no upper limit to the number
  of arguments.  If the function fails for any reason, it should call
  vp_err() and return NULL.  The function should check for the case where
  \c args is \c NULL, and treat it as if an empty list of arguments was
  passed.
*/
void
vp_func(vparser *p, char *name, vscalar *(*func)(vlist *args),
        int minargs, int maxargs)
{
    vpfunc *f, *oldf;

    VP_CHECK(p);

    f = V_ALLOC(vpfunc, 1);
    f->func = func;
    f->minargs = V_MIN(minargs, maxargs);
    f->maxargs = V_MAX(minargs, maxargs);
    
    if ((oldf = vh_pget(p->functions, name)) != NULL)
        V_DEALLOC(oldf);

    vh_pstore(p->functions, name, f);
}

/* Write parser to a stream */
int
vp_fwrite(vparser *p, FILE *fp)
{
    VP_CHECK(p);

    if (V_DEBUG(V_DBG_IO))
        v_info("Writing %s", v_vinfo(p));

    /* Write variables */
    if (!vh_fwrite(p->variables, fp))
        return 0;

    /* Write constant flags */
    if (!vh_fwrite(p->constants, fp))
        return 0;

    return 1;
}

/*!
  @brief   Return the value of a parser variable.
  @ingroup parser_access
  @param   p Parser.
  @param   name Variable name.
  @return  Its value.
*/
vscalar *
vp_get(vparser *p, char *name)
{
    vscalar *val;

    VP_CHECK(p);

    if ((val = vh_get(p->variables, name)) == NULL &&
        !p->undef_ok && vp_parser != NULL)
        vp_err("undefined variable \"%s\"", name);

    return val;
}

/*!
  @brief   Return whether a name exists as a constant.
  @ingroup parser_access
  @param   p Parser.
  @param   name Name.
  @return  Yes or no.
*/
int
vp_isconst(vparser *p, char *name)
{
    VP_CHECK(p);
    return vh_exists(p->constants, name);
}


/*!
  @brief   Return whether a name exists as a function.
  @ingroup parser_access
  @param   p Parser.
  @param   name Name.
  @return  Yes or no.
*/
int
vp_isfunc(vparser *p, char *name)
{
    VP_CHECK(p);
    return vh_exists(p->functions, name);
}

/* Print contents of a parser */
void
vp_print(vparser *p, FILE *fp)
{
    vscalar *elt;
    vlist *list;
    char *name;
    vpfunc *f;

    VP_CHECK(p);

    v_print_start();
    v_push_indent();

    v_print_type(vparser_type, p, fp);

    /* Print variables */
    v_indent(fp);
    fprintf(fp, "VARIABLES => LIST\n");
    v_push_indent();    

    list = vh_sortkeys(p->variables, NULL);
    vl_foreach(elt, list) {
        name = vs_sgetref(elt);
        v_indent(fp);
        fprintf(fp, "%s = %s", name, vh_sget(p->variables, name));
        if (vh_exists(p->constants, name))
            fprintf(fp, " (constant)");
        fprintf(fp, "\n");
    }

    v_pop_indent();

    /* Print functions */
    v_indent(fp);
    fprintf(fp, "FUNCTIONS => LIST\n");
    v_push_indent();    

    list = vh_sortkeys(p->functions, NULL);
    vl_foreach(elt, list) {
        name = vs_sgetref(elt);
        f = vh_pget(p->functions, name);
        v_indent(fp);
        fprintf(fp, "%s", name);

        if (f->minargs == f->maxargs)
            fprintf(fp, " (%d arg%s)", f->minargs,
                    (f->minargs == 1 ? "" : "s"));
        else if (f->maxargs == VP_FUNC_NOLIMIT)
            fprintf(fp, " (>= %d arg%s)", f->minargs,
                    (f->minargs == 1 ? "" : "s"));
        else if (f->minargs == 0)
            fprintf(fp, " (<= %d arg%s)", f->maxargs,
                    (f->maxargs == 1 ? "" : "s"));
        else
            fprintf(fp, " (%d-%d args)", f->minargs, f->maxargs);

        fprintf(fp, "\n");
    }

    v_pop_indent();

    /* That's it */
    v_pop_indent();
    v_print_finish();
}

/*!
  @brief   Set the value of a parser variable.
  @ingroup parser_access
  @param   p Parser.
  @param   name Variable name.
  @param   val Value to set.
*/
void
vp_store(vparser *p, char *name, vscalar *val)
{
    VP_CHECK(p);

    if (!vh_exists(p->constants, name))
        vh_store(p->variables, name, val);
    else
        vp_err("attempt to modify constant \"%s\"", name);
}

/*!
  @brief   Return the value of the last expression evaluated.
  @ingroup parser_exp
  @param   p Parser.
  @return  Expression value.
*/
vscalar *
vp_value(vparser *p)
{
    VP_CHECK(p);
    return p->value;
}

/* Lexer function */
static int
yylex(void)
{
    static vregex *re_int, *re_real, *re_intexp, *re_id, *re_token;
    extern vscalar *yylval;
    static int newline = 0;
    extern char *vp_input;
    static vhash *tokens;
    static int init = 0;
    static int eof = 0;
    vlist *keylist;
    vscalar *elt;
    vbuffer *b;
    char *key;
    int token;

    /* Initialise */
    if (!init) {
        init++;

        tokens = vh_create();
        vh_istore(tokens, "&&",   AND);
        vh_istore(tokens, "==",   EQ);
        vh_istore(tokens, ">=",   GE);
        vh_istore(tokens, ">",    GT);
        vh_istore(tokens, "<=",   LE);
        vh_istore(tokens, "<",    LT);
        vh_istore(tokens, "!=",   NE);
        vh_istore(tokens, "||",   OR);

        b = vb_create();
        vb_puts(b, "\\`\\(");
        keylist = vh_keys(tokens);
        vb_puts(b, vl_join(keylist, "\\|"));
        vl_destroy(keylist);
        vb_puts(b, "\\)");

        if ((re_token = vr_create(vb_get(b))) == NULL)
            v_fatal("invalid token regexp: %s", vr_error());
        v_cleanup(re_token);
        vb_destroy(b);

        if ((re_id = vr_create("\\`[A-Za-z_]\\w*")) == NULL)
            v_fatal("invalid ID regexp: %s", vr_error());
        v_cleanup(re_id);

        if ((re_int = vr_create("\\`[0-9]+")) == NULL)
            v_fatal("invalid integer regexp: %s", vr_error());
        v_cleanup(re_int);

        if ((re_intexp = vr_create("\\`[0-9]+[Ee]-?[0-9]+")) == NULL)
            v_fatal("invalid integer-exponent regexp: %s", vr_error());
        v_cleanup(re_intexp);

        if ((re_real = vr_create("\\`[0-9]*\\.[0-9]+\\([Ee]-?[0-9]+\\)?")) == NULL)
            v_fatal("invalid real regexp: %s", vr_error());
        v_cleanup(re_real);
    }

    /* Check for end-of-input */
    if (eof) {
        eof = 0;
        return 0;
    }

    /* Increment line number if required */
    if (newline) {
        vp_line_number++;
        newline = 0;
    }

    /* Scan input */
    while (1) {
        if        (*vp_input == '\0') {
            /* End of input -- fake a final newline */
            eof++;
            return '\n';
        } else if (*vp_input == '\n') {
            /* Newline */
            vp_input++;
            newline++;
            return '\n';
        } else if (isspace(*vp_input)) {
            /* Skip whitespace */
            vp_input++;
        } else if (*vp_input == '#') {
            /* Skip comments */
            while (*vp_input != '\n' && *vp_input != '\0')
                vp_input++;
        } else if (vr_match(vp_input, re_token)) {
            /* Token */
            char *val = vr_matched(0);
            token = vh_iget(tokens, val);
            vp_input += strlen(val);
            return token;
        } else if (vr_match(vp_input, re_id)) {
            /* ID -- variable, constant or function */
            char *val = vr_matched(0);
            yylval = vs_screate(val);
            vp_input += strlen(val);
            return ID;
        } else if (vr_match(vp_input, re_real)) {
            /* Real with decimal point and optional exponent */
            char *val = vr_matched(0);
            yylval = vs_dcreate(atof(val));
            vp_input += strlen(val);
            return VALUE;
        } else if (vr_match(vp_input, re_intexp)) {
            /* Integer with exponent */
            char *val = vr_matched(0);
            yylval = vs_dcreate(atof(val));
            vp_input += strlen(val);
            return VALUE;
        } else if (vr_match(vp_input, re_int)) {
            /* Integer */
            char *val = vr_matched(0);
            yylval = vs_icreate(atoi(val));
            vp_input += strlen(val);
            return VALUE;
        } else {
            /* Single character */
            return *vp_input++;
        }
    }

    /* NOTREACHED */
}

/* Parser print function */
static void
yyprint(FILE *fp, int type, vscalar *s)
{
    switch (type) {
    case ID:
    case VALUE:
        fprintf(fp, " %s", vs_sget(s));
        break;
    }
}

/* Parser error function */
static void
yyerror(char *msg)
{
    vp_err(msg);
}

/* Builtin functions */
static vscalar *
builtin_acos(vlist *args)
{
    return CALL_MATH_1(acos);
}

static vscalar *
builtin_asin(vlist *args)
{
    return CALL_MATH_1(asin);
}

static vscalar *
builtin_atan(vlist *args)
{
    return CALL_MATH_1(atan);
}

static vscalar *
builtin_atan2(vlist *args)
{
    return CALL_MATH_2(atan2);
}

static vscalar *
builtin_ceil(vlist *args)
{
    return CALL_MATH_1(ceil);
}

static vscalar *
builtin_cos(vlist *args)
{
    return CALL_MATH_1(cos);
}

static vscalar *
builtin_exp(vlist *args)
{
    return CALL_MATH_1(exp);
}

static vscalar *
builtin_fabs(vlist *args)
{
    return CALL_MATH_1(fabs);
}

static vscalar *
builtin_floor(vlist *args)
{
    return CALL_MATH_1(floor);
}

static vscalar *
builtin_fmod(vlist *args)
{
    return CALL_MATH_2(fmod);
}

static vscalar *
builtin_hypot(vlist *args)
{
    return CALL_MATH_2(hypot);
}

static vscalar *
builtin_log(vlist *args)
{
    return CALL_MATH_1(log);
}

static vscalar *
builtin_log10(vlist *args)
{
    return CALL_MATH_1(log10);
}

static vscalar *
builtin_max(vlist *args)
{
    double max = vl_dget(args, 0);
    vscalar *elt;

    vl_foreach(elt, args)
        max = V_MAX(max, vs_dget(elt));

    return vs_dcreate(max);
}

static vscalar *
builtin_min(vlist *args)
{
    double min = vl_dget(args, 0);
    vscalar *elt;

    vl_foreach(elt, args)
        min = V_MIN(min, vs_dget(elt));

    return vs_dcreate(min);
}

static vscalar *
builtin_pow(vlist *args)
{
    return CALL_MATH_2(pow);
}

static vscalar *
builtin_sin(vlist *args)
{
    return CALL_MATH_1(sin);
}

static vscalar *
builtin_sqrt(vlist *args)
{
    return CALL_MATH_1(sqrt);
}

static vscalar *
builtin_tan(vlist *args)
{
    return CALL_MATH_1(tan);
}
