/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */

/*!
  @file
  @brief Utility functions.
*/

#ifndef VARS_UTILS_H
#define VARS_UTILS_H

#include <setjmp.h>

#define V_HEXSTRING_SIZE        8

#define v_catch()               (catch_flag = setjmp(catch_buf))

extern jmp_buf catch_buf;
extern int catch_flag;

#ifdef __cplusplus
extern "C" {
#endif

extern int v_chop(char *str);
extern unsigned char *v_compress(unsigned char *data,
                                 unsigned long size,
                                 unsigned long *csize);
extern void v_die(char *fmt, ...);
extern void v_exception(char *fmt, ...);
extern void v_exception_hook(void (*func)(char *msg));
extern void v_fatal(char *fmt, ...);
extern void v_fatal_hook(void (*func)(char *msg));
extern char *v_hexstring(void *ptr, char *buf);
extern char *v_strdup(char *str);
extern void v_throw(int val);
extern void v_unavailable(char *name);
extern unsigned char *v_uncompress(unsigned char *cdata,
                                   unsigned long csize,
                                   unsigned long size);
extern void v_warn(char *fmt, ...);
extern void v_warn_internal(char *fmt, ...);

#ifdef __cplusplus
}
#endif

#endif
