/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */

/*!
  @file
  @brief Vector functions and macros.
  @ingroup vector
*/

#ifndef VARS_VECTOR_H
#define VARS_VECTOR_H

#include <vars-list.h>

/*! @brief Abort of a pointer is not a vector. */
#define VV_CHECK(ptr)      V_CHECK(ptr, vvector_type, "VECTOR")

/*! @brief Check if a pointer is a vector type. */
#define v_isvector(ptr)    (ptr != NULL && vt_type(ptr) == vvector_type) 

/*! @brief Vector type. */
typedef struct v_vector vvector;

/*! @brief Vector type variable. */
extern vtype *vvector_type;

#ifdef __cplusplus
extern "C" {
#endif

extern vvector *vv_copy(vvector *v);
extern vvector *vv_create(unsigned int size);
extern vvector *vv_create_vector(unsigned int size, ...);
extern vvector *vv_create_from_list(vlist *list);
extern vvector *vv_create_from_values(unsigned int size, float *values);
extern vvector *vv_create_with_values(unsigned int size, float *values);
extern vtype *vv_declare(void);
extern void vv_destroy(vvector *v);
extern vvector *vv_fread(FILE *fp);
extern int vv_freeze(vvector *v, FILE *fp);
extern void vv_freeze_format(char *string);
extern void vv_freeze_linesize(int size);
extern int vv_fwrite(vvector *v, FILE *fp);
extern float vv_get(vvector *v, int num);
extern float *vv_get_values(vvector *v);
extern float *vv_get_values_copy(vvector *v);
extern int vv_length(vvector *v);
extern void vv_print(vvector *v, FILE *fp);
extern void vv_print_format(char *string);
extern void vv_print_linesize(int size);
extern void vv_sort(vvector *v);
extern void vv_store(vvector *v, int num, float val);
extern void vv_store_values(vvector *v, float *values);
extern vvector *vv_thaw(FILE *fp);
extern int vv_traverse(vvector *v, int (*func)());

#ifdef __cplusplus
}
#endif

#endif
