/*
 * This file is part of the Vars library, copyright (C) Glenn
 * Hutchings 1996-2003.
 *
 * The Vars library comes with ABSOLUTELY NO WARRANTY.  This is free
 * software, and you are welcome to redistribute it under certain
 * conditions; see the file COPYING for details.
 */

/* User include file */

#ifndef VARS_H
#define VARS_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/* Configuration */
#include <vars-config.h>

/* Object types */
#include <vars-array.h>
#include <vars-buffer.h>
#include <vars-func.h>
#include <vars-graph.h>
#include <vars-hash.h>
#include <vars-image.h>
#include <vars-list.h>
#include <vars-matrix.h>
#include <vars-parser.h>
#include <vars-queue.h>
#include <vars-regex.h>
#include <vars-scalar.h>
#include <vars-vector.h>

/* Other stuff */
#include <vars-compat.h>
#include <vars-copy.h>
#include <vars-destroy.h>
#include <vars-getopt.h>
#include <vars-macros.h>
#include <vars-memory.h>
#include <vars-random.h>
#include <vars-system.h>
#include <vars-traverse.h>
#include <vars-type.h>
#include <vars-write.h>
#include <vars-utils.h>

#endif
