/* SWIG interface, in -*- C -*- mode */

%newobject va_points_s;
%newobject va_points_x;

VARS_TYPE(va, array, varray)

%define VA_TYPE_FUNCS(letter, type)

type letter ## get(float fval)
     {return va_ ## letter ## get ## (self, fval);}

type letter ## store(float fval, type val)
     {va_ ## letter ## store ## (self, fval, val); return val;}

%enddef

%extend v_array {
    //%apply float *OUTPUT { float *ret1 };
    //%apply vscalar **OUTPUT { vscalar **ret2 };
    //%apply vscalar **OUTPUT { vscalar **before };
    //%apply vscalar **OUTPUT { vscalar **after };
    //%apply float *OUTPUT { vscalar **fraction };

    VA_TYPE_FUNCS(i, int);
    VA_TYPE_FUNCS(f, float);
    VA_TYPE_FUNCS(d, double);
    VA_TYPE_FUNCS(s, char *);
    VA_TYPE_FUNCS(p, void *);

    float maximum(void) {return va_maximum(self);}
    float minimum(void) {return va_minimum(self);}

    int isdefined(float x) {return va_defined(self, x);}
    int delete(float x) {return va_delete(self, x);}
    int find(float x) {return va_find(self, x);}
    int point_count(void) {return va_point_count(self);}

    //int interp(float x, vscalar **before, vscalar **after, float *fraction)
    //{va_interp(self, x, before, after, fraction);}

    vlist *points_s(void) {return va_points_s(self);}
    vlist *points_x(void) {return va_points_x(self);}

    void add_list(vlist *x, vlist *s) {va_add_list(self, x, s);}
    void empty(void) {va_empty(self);}
    void resolution(float res) {va_resolution(self, res);}
    void store(float x, vscalar *s) {va_store(self, x, s);}

    //void get_point(int num, float *ret1, vscalar **ret2)
    //{va_get_point(self, num, ret1, ret2);}

    vscalar *get(float x) {return va_get(self, x);}
    vscalar *get_exact(float x) {return va_get_exact(self, x);}
}
