/* SWIG interface, in -*- C -*- mode */

%newobject vf_differential;
%newobject vf_integral;
%newobject vf_points_fx;
%newobject vf_points_x;

VARS_TYPE(vf, func, vfunc)

%extend v_func {
    double maximum(void) {return vf_maximum(self);}
    double minimum(void) {return vf_minimum(self);}

    double value(double x) {return vf_value(self, x);}
    double value_extrapolate(double x) {return vf_value_extrapolate(self, x);}
    double value_lagrange(double x) {return vf_value_lagrange(self, x);}
    double value_linear(double x) {return vf_value_linear(self, x);}
    double value_nearest(double x) {return vf_value_nearest(self, x);}
    double value_spline(double x) {return vf_value_spline(self, x);}

    int isdefined(double x) {vf_defined(self, x);}
    int point_count(void) {return vf_point_count(self);}

    vfunc *differential(void) {return vf_differential(self);}
    vfunc *integral(void) {return vf_integral(self);}

    vlist *points_fx(void) {return vf_points_fx(self);}
    vlist *points_x(void) {return vf_points_x(self);}

    void add_array(int num, double *x, double *fx)
        {vf_add_array(self, num, x, fx);}

    void add_func(double (*func)(double val),
                  double min, double max, unsigned int num)
        {vf_add_func(self, func, min, max, num);}

    void add_list(vlist *x, vlist *fx) {vf_add_list(self, x, fx);}
    void add_point(double x, double fx) {vf_add_point(self, x, fx);}

    void delete_point(int num) {vf_delete_point(self, num);}
    void empty(void) {vf_empty(self);}
    void interpolate(enum v_interptype type) {vf_interpolate(self, type);}
    void resolution(double res) {vf_resolution(self, res);}
    void set_cycle(double cycle) {vf_set_cycle(self, cycle);}

    void spline_deriv(double first, double last)
        {vf_spline_deriv(self, first, last);}

    %apply double *OUTPUT { double *ret1, double *ret2 };

    void get_point(int num, double *ret1, double *ret2)
        {vf_get_point(self, num, ret1, ret2);}

    void get_range(double *ret1, double *ret2)
        {vf_get_range(self, ret1, ret2);}
}
