/* SWIG interface, in -*- C -*- mode */

%newobject vg_connected;
%newobject vg_node_from;
%newobject vg_node_list;
%newobject vg_node_to;
%newobject vg_path_info;
%newobject vg_path_list;
%newobject vg_tsort;

VARS_TYPE(vg, graph, vgraph)

%define VG_TYPE_FUNCS(letter, type)

type node_ ## letter ## get(char *node)
     {return vg_node_ ## letter ## get ## (self, node);}

type node_ ## letter ## store(char *node, type val)
     {vg_node_ ## letter ## store ## (self, node, val); return val;}

type link_ ## letter ## get(char *n1, char *n2)
     {return vg_link_ ## letter ## get ## (self, n1, n2);}

type link_ ## letter ## store(char *n1, char *n2, type val)
     {vg_link_ ## letter ## store ## (self, n1, n2, val); return val;}

type link_oneway_ ## letter ## store(char *n1, char *n2, type val)
     {vg_link_oneway_ ## letter ## store ## (self, n1, n2, val); return val;}

%enddef

%extend v_graph {
    %apply int *OUTPUT { int *from, int *to };

    VG_TYPE_FUNCS(i, int);
    VG_TYPE_FUNCS(f, float);
    VG_TYPE_FUNCS(d, double);
    VG_TYPE_FUNCS(s, char *);
    VG_TYPE_FUNCS(p, void *);

    double path_cache(char *node) {return vg_path_cache(self, node);}

    double path_length(char *n1, char *n2)
        {return vg_path_length(self, n1, n2);}

    int link_count(void) {return vg_link_count(self);}
    int link_exists(char *n1, char *n2) {return vg_link_exists(self, n1, n2);}
    int node_count(void) {return vg_node_count(self);}
    int node_exists(char *node) {return vg_node_exists(self, node);}
    int path_exists(char *n1, char *n2) {return vg_path_exists(self, n1, n2);}

    int node_links(char *node, int *from, int *to)
        {return vg_node_links(self, node, from, to);}

    vlist *connected(void) {return vg_connected(self);}
    vlist *node_from(char *node) {return vg_node_from(self, node);}
    vlist *node_list(void) {return vg_node_list(self);}
    vlist *node_to(char *node) {return vg_node_to(self, node);}
    vlist *path_info(char *n1, char *n2) {return vg_path_info(self, n1, n2);}
    vlist *path_list(char *n1, char *n2) {return vg_path_list(self, n1, n2);}
    vlist *tsort(void) {return vg_tsort(self);}

    void delete(char *node) {vg_delete(self, node);}
    void link(char *n1, char *n2) {vg_link(self, n1, n2);}
    void node(char *name) {vg_node(self, name);}
    void node_store(char *node, vscalar *s) {vg_node_store(self, node, s);}
    void unlink(char *n1, char *n2) {vg_unlink(self, n1, n2);}
    void unlink_oneway(char *n1, char *n2) {vg_unlink_oneway(self, n1, n2);}
    void use_cache(int flag) {vg_use_cache(self, flag);}

    void link_store(char *n1, char *n2, vscalar *s)
        {vg_link_store(self, n1, n2, s);}

    void link_oneway_store(char *n1, char *n2, vscalar *s)
        {vg_link_oneway_store(self, n1, n2, s);}

    //void link_size_function(double (*func)(char *n1, char *n2, vscalar *s))
    //{vg_link_size_function(self, func);}

    //void use_link_function(int (*func)(char *n1, char *n2, vscalar *s))
    //{vg_use_link_function(self, func);}

    //void use_node_function(int (*func)(char *node, vscalar *s, double dist))
    //{vg_use_node_function(self, func);}

    vscalar *link_get(char *n1, char *n2) {return vg_link_get(self, n1, n2);}
    vscalar *node_get(char *node) {return vg_node_get(self, node);}
}

%inline %{
#undef vg_node
void vg_node(vgraph *g, char *node)
     {vg_node_store(g, node, vs_create(V_UNDEF));}

#undef vg_link
void vg_link(vgraph *g, char *n1, char *n2)
     {vg_link_store(g, n1, n2, vs_create(V_UNDEF));}

#undef vg_link_oneway
void vg_link_oneway(vgraph *g, char *n1, char *n2)
     {vg_link_oneway_store(g, n1, n2, vs_create(V_UNDEF));}
%}
