/* SWIG interface, in -*- C -*- mode */

%newobject vh_create_table;
%newobject vh_keys;
%newobject vh_values;
%newobject vh_sortkeys;
%newobject vh_sortvalues;

%ignore vh_hashinfo;
%ignore vh_keybuf;
%ignore vh_sortprint;

VARS_TYPE(vh, hash, vhash)

%define VH_TYPE_FUNCS(letter, type)

type letter ## get(char *key)
     {return vh_ ## letter ## get ## (self, key);}

type letter ## store(char *key, type val)
     {vh_ ## letter ## store ## (self, key, val); return val;}

%enddef

%extend v_hash {
    VH_TYPE_FUNCS(i, int);
    VH_TYPE_FUNCS(f, float);
    VH_TYPE_FUNCS(d, double);
    VH_TYPE_FUNCS(s, char *);
    VH_TYPE_FUNCS(p, void *);

    int isdefined(char *key) {return vh_defined(self, key);}
    int empty(void) {vh_empty(self);}
    int entry_count(void) {return vh_entry_count(self);} 
    int exists(char *key) {return vh_exists(self, key);}

    vlist *keys(void) {return vh_keys(self);}
    vlist *values(void) {return vh_values(self);}

    vlist *sortkeys(int (*compare)() = NULL)
        {return vh_sortkeys(self, compare);}

    vlist *sortvalues(int (*compare)() = NULL)
        {return vh_sortvalues(self, compare);}

    void delete(char *key) {vh_delete(self, key);}
    void store(char *key, vscalar *val) {vh_store(self, key, val);}
    void undef(char *key) {vh_undef(self, key);}

    vscalar *get(char *key) {return vh_get(self, key);}
}

%inline %{
#undef vh_create
vhash *vh_create(void)
      {return vh_create_table(0, 1);}
%}
