/* SWIG interface, in -*- C -*- mode */

%newobject vi_read_image;

%ignore vi_read_pgm;
%ignore vi_read_ppm;
%ignore vi_read_sgi;
%ignore vi_write_pgm;
%ignore vi_write_ppm;
%ignore vi_write_sgi;

VARS_TYPE(vi, image, vimage)

%extend v_image {
    int get_height(void) {vi_get_height(self);}
    int get_width(void) {vi_get_width(self);}

    %apply int *OUTPUT { int *ret1, int *ret2 };
    void get_size(int *ret1, int *ret2) {
        *ret1 = vi_get_width(self);
        *ret2 = vi_get_height(self);
    }

    int has_gray(void) {vi_has_gray(self);}
    int has_rgb(void) {vi_has_rgb(self);}
    int has_rgba(void) {vi_has_rgba(self);}

    int write_file(char *file, char *format)
        {return vi_write_file(self, file, format);}

    int write_image(char *file)
        {return vi_write_image(self, file);}

    %apply unsigned char *OUTPUT { unsigned char *val };

    int get_gray(int i, int j, unsigned char *val)
        {return vi_get_gray(self, i, j, val);}

    int set_gray(int i, int j, unsigned char val)
        {return vi_set_gray(self, i, j, val);}

    %apply unsigned char *OUTPUT { unsigned char *r,
                                   unsigned char *g,
                                   unsigned char *b };

    int get_rgb(int i, int j,
                unsigned char *r, unsigned char *g, unsigned char *b)
        {return vi_get_rgb(self, i, j, r, g, b);}

    int set_rgb(int i, int j,
                unsigned char r, unsigned char g, unsigned char b)
        {return vi_set_rgb(self, i, j, r, g, b);}

    unsigned char *get_graydata(void) {return vi_get_graydata(self);}
    unsigned char *get_grayrow(int row) {return vi_get_grayrow(self, row);}

    unsigned char *get_rgbdata(void) {return vi_get_rgbdata(self);}
    unsigned char *get_rgbrow(int row) {return vi_get_rgbrow(self, row);}

    void compress(int flag) {vi_compress(self, flag);}

    void delete_gray(void) {vi_delete_gray(self);}
    void delete_rgb(void) {vi_delete_rgb(self);}
    void need_gray(void) {vi_need_gray(self);}
    void need_rgb(void) {vi_need_rgb(self);}

    void set_graydata(unsigned char *data) {vi_set_graydata(self, data);}
    void set_rgbdata(unsigned char *data) {vi_set_rgbdata(self, data);}
}

%inline %{
#undef vi_read_image
vimage *vi_read_image(char *file)
    {return vi_read_file(file, NULL);}

#undef vi_write_image
int vi_write_image(vimage *image, char *file)
    {return vi_write_file(image, file, NULL);}
%}
