/* SWIG interface, in -*- C -*- mode */

%newobject vl_combine;
%newobject vl_concat;
%newobject vl_map;
%newobject vl_match;
%newobject vl_permute;
%newobject vl_reverse;
%newobject vl_splice;

%ignore vl_search_list;
%ignore vl_sort_inplace;
%ignore vl_split_string;

VARS_TYPE(vl, list, vlist)

%define VL_TYPE_FUNCS(letter, type)

type letter ## get(int num)
     {return vl_ ## letter ## get ## (self, num);}

type letter ## store(int num, type val)
     {vl_ ## letter ## store ## (self, num, val); return val;}

type letter ## pop(void)
     {return vl_ ## letter ## pop ## (self);}

type letter ## push(type val)
     {vl_ ## letter ## push ## (self, val); return val;}

type letter ## shift(void)
     {return vl_ ## letter ## shift ## (self);}

type letter ## unshift(type val)
     {vl_ ## letter ## unshift ## (self, val); return val;}

type letter ## head(void)
     {return vl_ ## letter ## head ## (self);}

type letter ## tail(void)
     {return vl_ ## letter ## tail ## (self);}

int letter ## search(type val, int (*compare)(vscalar **s1, vscalar **s2),
                     int match)
     {return vl_search_list(self, vs_ ## letter ## create(val),
                            compare, match, 1);}

%enddef

%extend v_list {
    VL_TYPE_FUNCS(i, int);
    VL_TYPE_FUNCS(f, float);
    VL_TYPE_FUNCS(d, double);
    VL_TYPE_FUNCS(s, char *);
    VL_TYPE_FUNCS(p, void *);

    char *join(char *delim) {return vl_join(self, delim);}
    char *join_text(char *endings) {return vl_join_text(self, endings);}

    int isdefined(int num) {return vl_defined(self, num);}
    int length(void) {return vl_length(self);}

    int search(vscalar *s, int (*compare)(vscalar **s1, vscalar **s2),
               int match)
        {return vl_search_list(self, s, compare, match, 0);}

    vlist *combine(int num) {return vl_combine(self, num);}
    vlist *concat(vlist *other) {return vl_concat(self, other);}
    vlist *map(vscalar *(*func)(vscalar *s)) {return vl_map(self, func);}
    vlist *match(int (*func)(vscalar *s)) {return vl_match(self, func);}
    vlist *permute(int num) {return vl_permute(self, num);}
    vlist *reverse(void) {return vl_reverse(self);}

    vlist *splice(int offset, int length, vlist *r)
        {return vl_splice(self, offset, length, r);}

    void append(vlist *a) {vl_append(self, a);}
    void apply(void (*func)(vscalar *s)) {vl_apply(self, func);}
    void empty(void) {vl_empty(self);}
    void push(vscalar *s) {vl_push(self, s);}
    void sort(void) {vl_sort_inplace(self, NULL);}
    void store(int num, vscalar *s) {vl_store(self, num, s);}
    void undef(int num) {vl_undef(self, num);}
    void unshift(vscalar *s) {vl_unshift(self, s);}

    vscalar *get(int num) {return vl_get(self, num);}
    vscalar *head(void) {return vl_head(self);}
    vscalar *pop(void) {return vl_pop(self);}
    vscalar *shift(void) {return vl_shift(self);}
    vscalar *tail(void) {return vl_tail(self);}
}

%inline %{
#undef vl_split
vlist *vl_split(char *s, char *delim)
      {return vl_split_string(s, delim, NULL, 0);}

#undef vl_nsplit
vlist *vl_nsplit(char *s, char *delim)
      {return vl_split_string(s, delim, NULL, 1);}

#undef vl_qsplit
vlist *vl_qsplit(char *s, char *delim, char *quote)
      {return vl_split_string(s, delim, quote, 0);}

#undef vl_qnsplit
vlist *vl_qnsplit(char *s, char *delim, char *quote)
      {return vl_split_string(s, delim, quote, 1);}
%}
