/* SWIG interface, in -*- C -*- mode */

%newobject vp_call;

VARS_TYPE(vp, parser, vparser)

%define VP_TYPE_FUNCS(letter, type)

type letter ## get(char *name)
     {return vp_ ## letter ## get ## (self, name);}

type letter ## value(void)
     {return vp_ ## letter ## value ## (self);}

type letter ## const(char *name, type val)
     {vp_ ## letter ## const ## (self, name, val);}

type letter ## store(char *name, type val)
     {vp_ ## letter ## store ## (self, name, val); return val;}

%enddef

%extend v_parser {
    VP_TYPE_FUNCS(i, int);
    VP_TYPE_FUNCS(d, double);
    VP_TYPE_FUNCS(s, char *);

    char *error(void) {return vp_error(self);}

    int eval(char *expr) {return vp_eval(self, expr);}
    int exists(char *name) {return vp_exists(self, name);}
    int isconst(char *name) {return vp_isconst(self, name);}
    int isfunc(char *name) {return vp_isfunc(self, name);}

    vlist *errors(void) {return vp_errors(self);}

    void constant(char *name, vscalar *val) {vp_const(self, name, val);}
    void delconst(char *name) {vp_delconst(self, name);}
    void delfunc(char *name) {vp_delfunc(self, name);}
    void error_undef(int flag) {vp_error_undef(self, flag);}
    void store(char *name, vscalar *val) {vp_store(self, name, val);}

    void func(char *name, vscalar *(*func)(vlist *args),
              int minargs, int maxargs)
        {vp_func(self, name, func, minargs, maxargs);}

    void func_any(char *name, vscalar *(*func)(vlist *args))
        {vp_func(self, name, func, 0, VP_FUNC_NOLIMIT);}

    void func_args(char *name, vscalar *(*func)(vlist *args), int num)
        {vp_func(self, name, func, num, num);}

    void func_max(char *name, vscalar *(*func)(vlist *args), int maxargs)
        {vp_func(self, name, func, 0, maxargs);}

    void func_min(char *name, vscalar *(*func)(vlist *args), int minargs)
        {vp_func(self, name, func, minargs, VP_FUNC_NOLIMIT);}

    vscalar *call(char *name, vlist *args) {return vp_call(self, name, args);}
    vscalar *get(char *name) {return vp_get(self, name);}
    vscalar *value(void) {return vp_value(self);}
}
