/* SWIG interface, in -*- C -*- mode */

VARS_TYPE(vq, queue, vqueue)

%define VQ_TYPE_FUNCS(letter, type)

type letter ## get(void)
     {return vq_ ## letter ## get ## (self);}

type letter ## head(void)
     {return vq_ ## letter ## head ## (self);}

type letter ## store(type val, double priority)
     {vq_ ## letter ## store ## (self, val, priority); return val;}

%enddef

%extend v_queue {
    VQ_TYPE_FUNCS(i, int);
    VQ_TYPE_FUNCS(f, float);
    VQ_TYPE_FUNCS(d, double);
    VQ_TYPE_FUNCS(s, char *);
    VQ_TYPE_FUNCS(p, void *);

    int length(void) {return vq_length(self);}

    void empty(void) {vq_empty(self);}
    void store(vscalar *s, double priority) {vq_store(self, s, priority);}

    vscalar *get(void) {return vq_get(self);}
    vscalar *head(void) {return vq_head(self);}
}
