/* SWIG interface, in -*- C -*- mode */

%newobject vs_icreate;
%newobject vs_fcreate;
%newobject vs_dcreate;
%newobject vs_screate;
%newobject vs_pcreate;

%ignore vs_sgetref;
%ignore vs_sget_buf;
%ignore vs_sstore_len;

VARS_TYPE(vs, scalar, vscalar)

%define VS_TYPE_FUNCS(letter, type)

type letter ## get(void)
     {return vs_ ## letter ## get ## (self);}

type letter ## store(type val)
     {vs_ ## letter ## store ## (self, val); return val;}

%enddef

%extend v_scalar {
    VS_TYPE_FUNCS(i, int);
    VS_TYPE_FUNCS(f, float);
    VS_TYPE_FUNCS(d, double);
    VS_TYPE_FUNCS(s, char *);
    VS_TYPE_FUNCS(p, void *);
}

%inline %{
#undef vs_icreate
#undef vs_fcreate
#undef vs_dcreate
#undef vs_screate
#undef vs_pcreate
vscalar *vs_icreate(int val)    {return vs_istore(NULL, val);}
vscalar *vs_fcreate(float val)  {return vs_fstore(NULL, val);}
vscalar *vs_dcreate(double val) {return vs_dstore(NULL, val);}
vscalar *vs_screate(char *val)  {return vs_sstore(NULL, val);}
vscalar *vs_pcreate(void *val)  {return vs_pstore(NULL, val);}
%}
