/* Vars SWIG definitions, in -*- C -*- mode */

%include "exception.i"
%include "typemaps.i"

%nodefault;

/* Standard header stuff */
%header %{
#include <vars.h>
%}

/* Catch exceptions */
%header %{
#define EXCEPT_BEFORE                                                   \
        exception = 0

#define EXCEPT_AFTER                                                    \
        if (exception) SWIG_exception(SWIG_RuntimeError, exception_msg)

static int exception = 0;
static char exception_msg[256];

void catch_exception(char *msg) {
    strcpy(exception_msg, msg);
    exception++;
}
%}

%init %{
    v_exception_hook(catch_exception);
%}

%exception {
    EXCEPT_BEFORE; $action; EXCEPT_AFTER;
}

/* Macro to declare a Vars type */
%define VARS_TYPE(prefix, name, type)

%newobject prefix ## _create;

%ignore prefix ## _break;
%ignore prefix ## _copy;
%ignore prefix ## _each;
%ignore prefix ## _each_start;
%ignore prefix ## _declare;
%ignore prefix ## _destroy;
%ignore prefix ## _fread;
%ignore prefix ## _freeze;
%ignore prefix ## _fwrite;
%ignore prefix ## _print;
%ignore prefix ## _thaw;
%ignore prefix ## _traverse;

%ignore type ## _type;

%include vars- ## name ## .h

struct v_ ## name {};

VARS_CONVERT(prefix, name, type);

/* General methods */
%extend v_ ## name {
    VARS_EXTEND(prefix, name, type);

    void show(void) {v_print(self, stdout);}

    type *copy(void)       {return prefix ## _copy(self);}
    type *deepcopy(void)   {return v_copy(self);}

    int freeze(char *file) {return v_freeze_file(self, file);}
}

/* Test if pointer is correct type */
%inline %{
int prefix ## _test(void *ptr) {
    return v_is ## name ## (ptr);
}
%}

%enddef
